/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.widget;

import de.jtem.jrworkspace.logging.LoggingSystem;
import de.jtem.jrworkspace.plugin.simplecontroller.SimpleController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SaveOnExitDialog {
    private File file = null;
    private final boolean[] yesNoCanceled;
    final JTextField filenameTF;
    final JCheckBox rememberCB;
    final JCheckBox loadCB;
    final SimpleController controller;
    private final JDialog dialog;

    public SaveOnExitDialog(File file, JFrame mainWindow, SimpleController controller) {
        boolean[] blArray = new boolean[3];
        blArray[2] = true;
        this.yesNoCanceled = blArray;
        this.filenameTF = new JTextField();
        this.rememberCB = new JCheckBox("Remember my decision.");
        this.loadCB = new JCheckBox("Load properties from this file on startup.");
        if (controller == null) {
            throw new NullPointerException();
        }
        this.controller = controller;
        this.dialog = new JDialog(mainWindow, "Save properties?", true);
        final JFileChooser fileChooser = new JFileChooser();
        if (file != null) {
            fileChooser.setSelectedFile(file.getAbsoluteFile());
        }
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setFileFilter(new PropertiesFileFilter());
        JLabel question = new JLabel("Do you want to save the properties?");
        JLabel filenameLabel = new JLabel("File: ");
        this.filenameTF.setText(file == null ? "" : file.getAbsolutePath());
        this.filenameTF.setMinimumSize(new Dimension(200, 10));
        int width = this.filenameTF.getPreferredSize().width;
        this.filenameTF.setPreferredSize(new Dimension(width > 200 ? width : 200, 15));
        JButton chooseButton = new JButton("Choose...");
        chooseButton.setMargin(new Insets(0, 20, 0, 20));
        this.rememberCB.setSelected(!controller.isAskBeforeSaveOnExit());
        this.loadCB.setSelected(controller.isLoadFromUserPropertyFile());
        JButton noButton = new JButton("No");
        noButton.setMargin(new Insets(0, 20, 0, 20));
        JButton yesButton = new JButton("Yes");
        yesButton.setMargin(new Insets(0, 20, 0, 20));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMargin(new Insets(0, 20, 0, 20));
        chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser.setSelectedFile(new File(SaveOnExitDialog.this.filenameTF.getText()));
                int choice = fileChooser.showDialog(SaveOnExitDialog.this.dialog, "Select");
                if (choice == 0) {
                    SaveOnExitDialog.this.filenameTF.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[0] = true;
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[2] = false;
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[1] = false;
                SaveOnExitDialog.this.dialog.setVisible(false);
            }
        });
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[1] = true;
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[2] = false;
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[0] = false;
                SaveOnExitDialog.this.dialog.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[2] = true;
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[1] = false;
                ((SaveOnExitDialog)SaveOnExitDialog.this).yesNoCanceled[0] = false;
                SaveOnExitDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog.getRootPane().setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 17;
        gbConstraints.gridwidth = 0;
        gbConstraints.ipady = 20;
        gbConstraints.ipadx = 5;
        this.dialog.add((Component)question, gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.ipady = 5;
        this.dialog.add((Component)filenameLabel, gbConstraints);
        this.dialog.add((Component)this.filenameTF, gbConstraints);
        this.dialog.add(Box.createHorizontalStrut(10), gbConstraints);
        gbConstraints.gridwidth = 0;
        this.dialog.add((Component)chooseButton, gbConstraints);
        this.dialog.add((Component)this.rememberCB, gbConstraints);
        this.dialog.add((Component)this.loadCB, gbConstraints);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder());
        buttonBox.add(yesButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(noButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(cancelButton);
        gbConstraints.gridwidth = 0;
        gbConstraints.anchor = 13;
        this.dialog.add((Component)buttonBox, gbConstraints);
    }

    public boolean show() {
        LoggingSystem.LOGGER.entering(SaveOnExitDialog.class.getName(), "show");
        this.yesNoCanceled[1] = false;
        this.yesNoCanceled[0] = false;
        this.yesNoCanceled[2] = true;
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.file = null;
        while (this.file == null) {
            this.dialog.setLocationByPlatform(true);
            this.dialog.setLocationRelativeTo(this.dialog.getParent());
            this.dialog.setVisible(true);
            if (this.yesNoCanceled[2]) {
                LoggingSystem.LOGGER.exiting(SaveOnExitDialog.class.getName(), "show", false);
                return false;
            }
            if (this.yesNoCanceled[1]) {
                this.controller.setAskBeforeSaveOnExit(!this.rememberCB.isSelected());
                this.controller.setUserPropertyFile(this.filenameTF.getText());
                this.controller.setLoadFromUserPropertyFile(this.loadCB.isSelected());
                if (!this.rememberCB.isSelected()) break;
                this.controller.setSaveOnExit(false);
                break;
            }
            if (!$assertionsDisabled) {
                this.yesNoCanceled[0] = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.controller.setAskBeforeSaveOnExit(!this.rememberCB.isSelected());
            this.controller.setUserPropertyFile(this.filenameTF.getText());
            this.controller.setLoadFromUserPropertyFile(this.loadCB.isSelected());
            if (this.rememberCB.isSelected()) {
                this.controller.setSaveOnExit(true);
            }
            this.file = new File(this.filenameTF.getText());
            try {
                if (this.file != null && this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
                    this.file.getParentFile().mkdirs();
                }
            }
            catch (Exception e) {
                this.file = null;
                JOptionPane.showMessageDialog(this.dialog.getParent(), "Can not write to file: " + this.file, "", 0);
            }
            this.yesNoCanceled[1] = false;
            this.yesNoCanceled[0] = false;
            this.yesNoCanceled[2] = true;
        }
        LoggingSystem.LOGGER.exiting(SaveOnExitDialog.class.getName(), "show", true);
        return true;
    }

    public File getFile() {
        return this.file;
    }

    public static class PropertiesFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            return name.endsWith(".xml") || name.endsWith(".jrw");
        }

        @Override
        public String getDescription() {
            return "Property Files (*.xml, *.jrw)";
        }
    }
}

