/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.widget;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    ArrayList<TreeModelListener> listeners;
    Object root;

    protected AbstractTreeModel(Object root) {
        this.root = root;
        this.listeners = new ArrayList();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireNodesAdded(Object parent, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireNodesAdded(parent, this.getIndicesFor(parent, child), child);
    }

    protected void fireNodesAdded(Object parent, int[] indices, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent), indices, child);
        int i = this.listeners.size() - 1;
        while (i > -1) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeNodesInserted(e);
            --i;
        }
    }

    protected void fireNodesChanged(Object parent, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireNodesChanged(parent, this.getIndicesFor(parent, child), child);
    }

    protected void fireNodesChanged(Object parent, int[] indices, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent), indices, child);
        int i = this.listeners.size() - 1;
        while (i > -1) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeNodesChanged(e);
            --i;
        }
    }

    protected void fireTreeStructureChanged(Object parent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent));
        int i = this.listeners.size() - 1;
        while (i > -1) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeStructureChanged(e);
            --i;
        }
    }

    protected void fireNodesRemoved(Object parent, int[] indices, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent), indices, child);
        int i = this.listeners.size() - 1;
        while (i > -1) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeNodesRemoved(e);
            --i;
        }
    }

    public TreePath getPathTo(Object o) {
        Object root = this.getRoot();
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(o);
        Object p = o;
        while (!root.equals(p)) {
            p = this.getParent(p);
            path.add(p);
        }
        Collections.reverse(path);
        return new TreePath(path.toArray());
    }

    protected int[] getIndicesFor(Object parent, Object[] child) {
        int[] indices = new int[child.length];
        int i = 0;
        while (i < indices.length) {
            indices[i] = this.getIndexOfChild(parent, child[i]);
            ++i;
        }
        return indices;
    }

    @Override
    public abstract Object getChild(Object var1, int var2);

    @Override
    public abstract int getChildCount(Object var1);

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int l = this.getChildCount(parent);
        int i = 0;
        while (i < l) {
            if (this.getChild(parent, i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public abstract Object getParent(Object var1);
}

