/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.sidecontainer.template;

import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.flavor.HelpFlavor;
import de.jtem.jrworkspace.plugin.flavor.UIFlavor;
import de.jtem.jrworkspace.plugin.sidecontainer.SideContainerPerspective;
import de.jtem.jrworkspace.plugin.sidecontainer.image.ImageHook;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;

public abstract class ShrinkPanelPlugin
extends Plugin
implements UIFlavor,
HelpFlavor,
ShrinkPanel.HelpCalledListener,
ShrinkPanel.HideCalledListener {
    private SideContainerPerspective perspective = null;
    protected ShrinkPanel shrinkPanel = null;
    private boolean showPanel = true;
    private JCheckBoxMenuItem menuItem = null;
    private int initPosition = 1;
    private Controller c = null;
    private static Icon defaultIcon = ImageHook.getIcon("menu.png");
    private HelpFlavor.HelpListener helpListener = null;
    private String helpDocument;
    private String helpPath;
    private Class<?> helpHandle;
    private boolean helpResourceChecked = false;
    public static final int SHRINKER_LEFT = 1;
    public static final int SHRINKER_RIGHT = 2;
    public static final int SHRINKER_BOTTOM = 3;
    public static final int SHRINKER_TOP = 4;
    public static final int SHRINKER_DEFAULT = 5;

    public abstract Class<? extends SideContainerPerspective> getPerspectivePluginClass();

    public ShrinkPanelPlugin() {
        if (this.getPluginInfo() == null) {
            throw new NullPointerException("PluginInfo must not be null.");
        }
        this.shrinkPanel = new ShrinkPanel(this.getPluginInfo().name);
        this.shrinkPanel.setShowHelpIcon(true);
        this.shrinkPanel.setHelpCalledListener(this);
        this.shrinkPanel.setShowHideIcon(true);
        this.shrinkPanel.setHideCalledListener(this);
        this.shrinkPanel.setIcon(this.getPluginInfo().icon);
        Icon smallIcon = null;
        if (this.getPluginInfo().icon != null) {
            smallIcon = ImageHook.scaleIcon(this.getPluginInfo().icon, 16, 16);
        }
        if (smallIcon == null) {
            smallIcon = defaultIcon;
        }
        this.menuItem = new JCheckBoxMenuItem(this.getPluginInfo().name, smallIcon);
        this.menuItem.addActionListener(new ShowPanelListener());
    }

    public void setInitialPosition(int initPosition) {
        this.initPosition = initPosition;
    }

    public void setShowPanel(boolean show) {
        this.showPanel = show;
        if (this.perspective == null) {
            return;
        }
        if (show) {
            switch (this.initPosition) {
                default: {
                    this.perspective.getLeftSlot().addShrinkPanel(this.getShrinkPanel());
                    break;
                }
                case 2: {
                    this.perspective.getRightSlot().addShrinkPanel(this.getShrinkPanel());
                    break;
                }
                case 4: {
                    this.perspective.getUpperSlot().addShrinkPanel(this.getShrinkPanel());
                    break;
                }
                case 3: {
                    this.perspective.getLowerSlot().addShrinkPanel(this.getShrinkPanel());
                    break;
                }
            }
        } else if (this.getShrinkPanel().getParentSlot() != null) {
            this.initPosition = this.getPosition();
            if (this.getShrinkPanel().isFloating()) {
                this.getShrinkPanel().setFloating(false);
            }
            this.getShrinkPanel().getParentSlot().removeShrinkPanel(this.getShrinkPanel());
        }
        if (this.menuItem != null) {
            this.menuItem.setSelected(show);
        }
    }

    private int getPosition() {
        SideContainerPerspective scp = this.c.getPlugin(this.getPerspectivePluginClass());
        if (this.getShrinkPanel().getParentSlot() == scp.getLeftSlot()) {
            return 1;
        }
        if (this.getShrinkPanel().getParentSlot() == scp.getRightSlot()) {
            return 2;
        }
        if (this.getShrinkPanel().getParentSlot() == scp.getUpperSlot()) {
            return 4;
        }
        if (this.getShrinkPanel().getParentSlot() == scp.getLowerSlot()) {
            return 3;
        }
        return 5;
    }

    public ShrinkPanel getShrinkPanel() {
        return this.shrinkPanel;
    }

    @Override
    public void install(Controller c) throws Exception {
        this.c = c;
        this.perspective = c.getPlugin(this.getPerspectivePluginClass());
        this.perspective.getPanelsMenu().add(this.menuItem);
        this.menuItem.setSelected(this.showPanel);
        this.setShowPanel(this.showPanel);
    }

    @Override
    public void restoreStates(Controller c) throws Exception {
        this.getShrinkPanel().setShrinked(c.getProperty(this.getClass(), "shrinked", this.getShrinkPanel().isShrinked()));
        this.showPanel = c.getProperty(this.getClass(), "showPanel", this.showPanel);
        this.initPosition = c.getProperty(this.getClass(), "initPosition", this.initPosition);
        this.getShrinkPanel().setPreferredPosition(c.getProperty(this.getClass(), "preferredPosition", 0));
        super.restoreStates(c);
    }

    @Override
    public void storeStates(Controller c) throws Exception {
        c.storeProperty(this.getClass(), "shrinked", this.getShrinkPanel().isShrinked());
        c.storeProperty(this.getClass(), "showPanel", this.showPanel);
        c.storeProperty(this.getClass(), "initPosition", this.getPosition());
        c.storeProperty(this.getClass(), "preferredPosition", this.getShrinkPanel().getPreferredPosition());
        super.storeStates(c);
    }

    @Override
    public void uninstall(Controller c) throws Exception {
        SideContainerPerspective scp = c.getPlugin(this.getPerspectivePluginClass());
        scp.getPanelsMenu().remove(this.menuItem);
        if (this.getShrinkPanel().isFloating()) {
            this.getShrinkPanel().setFloating(false);
        }
        if (this.getShrinkPanel().getParentSlot() != null) {
            this.getShrinkPanel().getParentSlot().removeShrinkPanel(this.getShrinkPanel());
        }
    }

    @Override
    public void mainUIChanged(String uiClass) {
        SwingUtilities.updateComponentTreeUI(this.getShrinkPanel());
    }

    @Override
    public void hideCalled() {
        this.setShowPanel(false);
    }

    @Override
    public void helpCalled() {
        if (this.helpListener != null) {
            this.helpListener.showHelpPage(this);
        }
    }

    @Override
    public String getHelpTitle() {
        return this.getPluginInfo().name;
    }

    @Override
    public Icon getHelpIcon() {
        return this.getPluginInfo().icon;
    }

    @Override
    public String getHelpDocument() {
        this.checkHelpResource();
        return this.helpDocument == null ? "default.html" : this.helpDocument;
    }

    @Override
    public String getHelpPath() {
        this.checkHelpResource();
        return this.helpPath == null ? "help/" : this.helpPath;
    }

    @Override
    public Class<?> getHelpHandle() {
        this.checkHelpResource();
        return this.helpHandle == null ? ShrinkPanelPlugin.class : this.helpHandle;
    }

    private void checkHelpResource() {
        if (this.helpResourceChecked) {
            return;
        }
        Class<?> clazz = this.getClass();
        while (clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        String filename = String.valueOf(clazz.getSimpleName()) + ".html";
        if (clazz.getResource(filename) != null) {
            this.helpDocument = filename;
            this.helpPath = "";
            this.helpHandle = clazz;
        }
        this.helpResourceChecked = true;
    }

    @Override
    public String getHelpStyleSheet() {
        return null;
    }

    @Override
    public void setHelpListener(HelpFlavor.HelpListener l) {
        this.helpListener = l;
    }

    public static Icon getDefaultIcon() {
        return defaultIcon;
    }

    private class ShowPanelListener
    implements ActionListener {
        private ShowPanelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShrinkPanelPlugin.this.getShrinkPanel().setShrinked(false);
            ShrinkPanelPlugin.this.setShowPanel(ShrinkPanelPlugin.this.menuItem.isSelected());
        }
    }
}

