/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.mesh;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Edge {
    static final int MAX_VERTEX_INDEX = (int)Math.sqrt(2.147483645E9);
    public final int v1;
    public final int v2;

    public Edge(int v1, int v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    static int hashCode(int v1, int v2) {
        return v1 > v2 ? v1 * MAX_VERTEX_INDEX + v2 : v2 * MAX_VERTEX_INDEX + v1;
    }

    public final int hashCode() {
        return Edge.hashCode(this.v1, this.v2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge we = (Edge)o;
        return this.v1 == we.v1 && this.v2 == we.v2 || this.v1 == we.v2 && this.v2 == we.v1;
    }

    public final boolean containsVertex(int index) {
        return this.v1 == index || this.v2 == index;
    }

    public final int getCommonVertex(Edge we) {
        if (we.containsVertex(this.v1)) {
            return this.v1;
        }
        if (we.containsVertex(this.v2)) {
            return this.v2;
        }
        throw new IllegalArgumentException("edges do not share common vertex");
    }

    int getOtherVertex(int index) {
        if (this.v1 == index) {
            return this.v2;
        }
        if (this.v2 == index) {
            return this.v1;
        }
        throw new IllegalArgumentException("given index is not a vertex of the edge");
    }

    public static void computeEdgesOfIndexedFaceSet(int[][] ifs, Set innerEdges, Set boundaryEdges) {
        HashMap hm = new HashMap();
        if (innerEdges != null) {
            innerEdges.clear();
        } else {
            innerEdges = new HashSet();
        }
        if (boundaryEdges != null) {
            boundaryEdges.clear();
        } else {
            boundaryEdges = new HashSet();
        }
        int nof = ifs.length;
        int i = 0;
        while (i < nof) {
            int[] face = ifs[i];
            int j = 1;
            while (j < face.length) {
                Edge.addEdge(innerEdges, hm, i, face[j - 1], face[j]);
                ++j;
            }
            Edge.addEdge(innerEdges, hm, i, face[face.length - 1], face[0]);
            ++i;
        }
        boundaryEdges.addAll(hm.values());
    }

    private static void addEdge(Set innerEdges, HashMap hm, int face, int k, int l) {
        Edge we1 = new Edge(k, l);
        Winged we2 = (Winged)hm.get(we1);
        if (we2 != null) {
            hm.remove(we1);
            innerEdges.add(new Winged(we2.v1, we2.v2, we2.f1, face));
        } else {
            hm.put(we1, new Winged(k, l, face));
        }
    }

    public static HashSet getWingedEdgesOfIndexedFaceSet(int[][] ifs) {
        HashSet innerEdges = new HashSet();
        HashSet boundaryEdges = new HashSet();
        Edge.computeEdgesOfIndexedFaceSet(ifs, innerEdges, boundaryEdges);
        innerEdges.addAll(boundaryEdges);
        return innerEdges;
    }

    public static HashSet getInnerEdgesOfIndexedFaceSet(int[][] ifs) {
        HashSet innerEdges = new HashSet();
        HashSet boundaryEdges = new HashSet();
        Edge.computeEdgesOfIndexedFaceSet(ifs, innerEdges, boundaryEdges);
        return innerEdges;
    }

    public static HashSet getBoundaryEdgesOfIndexedFaceSet(int[][] ifs) {
        HashSet innerEdges = new HashSet();
        HashSet boundaryEdges = new HashSet();
        Edge.computeEdgesOfIndexedFaceSet(ifs, innerEdges, boundaryEdges);
        return boundaryEdges;
    }

    public static int[][] getBoundaryOfIndexedFaceSet(int[][] ifs) {
        return Edge.stripEdges(Edge.getBoundaryEdgesOfIndexedFaceSet(ifs));
    }

    public static int[][] stripEdges(Set hs) {
        Vector lines = new Vector();
        Edge.stripEdges(hs, lines);
        int[][] ils = new int[lines.size()][];
        int i = 0;
        while (i < ils.length) {
            List line = (List)lines.get(i);
            ils[i] = new int[line.size() + 1];
            Edge firstEdge = (Edge)line.get(0);
            if (ils[i].length == 2) {
                ils[i][0] = firstEdge.v1;
                ils[i][1] = firstEdge.v2;
            }
            ils[i][1] = firstEdge.getCommonVertex((Edge)line.get(1));
            ils[i][0] = firstEdge.getOtherVertex(ils[i][1]);
            int j = 2;
            while (j < ils[i].length) {
                ils[i][j] = ((Edge)line.get(j - 1)).getOtherVertex(ils[i][j - 1]);
                ++j;
            }
            ++i;
        }
        return ils;
    }

    public static int[][] getBoundaryLinesOfIndexedFaceSet(int[][] ifs) {
        return Edge.stripEdges(Edge.getBoundaryEdgesOfIndexedFaceSet(ifs));
    }

    public static void stripEdges(Set edges, Collection lines) {
        lines.clear();
        Vector<Edge> usedEdges = new Vector<Edge>();
        while (!edges.isEmpty()) {
            Iterator iter = edges.iterator();
            Edge we1 = (Edge)iter.next();
            int firstIndex = we1.v1;
            int lastIndex = we1.v2;
            LinkedList<Edge> line = new LinkedList<Edge>();
            usedEdges.clear();
            usedEdges.add(we1);
            line.add(we1);
            while (true) {
                if (iter.hasNext()) {
                    Edge we2 = (Edge)iter.next();
                    if (we2.containsVertex(firstIndex)) {
                        firstIndex = we2.getOtherVertex(firstIndex);
                        line.addFirst(we2);
                        usedEdges.add(we2);
                        continue;
                    }
                    if (!we2.containsVertex(lastIndex)) continue;
                    lastIndex = we2.getOtherVertex(lastIndex);
                    line.addLast(we2);
                    usedEdges.add(we2);
                    continue;
                }
                edges.removeAll(usedEdges);
                if (usedEdges.isEmpty()) break;
                usedEdges.clear();
                iter = edges.iterator();
            }
            lines.add(line);
        }
    }

    public String toString() {
        return "(v1=" + this.v1 + ",v2=" + this.v2 + ")";
    }

    public static void main(String[] arg) {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[4];
        nArray[1] = 5;
        nArray[2] = 4;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 4, 3};
        nArrayArray[2] = new int[]{1, 3, 2};
        int[][] ifs = nArrayArray;
        System.out.println(Edge.getBoundaryEdgesOfIndexedFaceSet(ifs));
        int[][] ils = Edge.stripEdges(Edge.getBoundaryEdgesOfIndexedFaceSet(ifs));
        int i = 0;
        while (i < ils.length) {
            int j = 0;
            while (j < ils[i].length) {
                System.out.print("->" + ils[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static class Winged
    extends Edge {
        public static final int NO_FACE = -1;
        public final int f1;
        public final int f2;

        public Winged(int v1, int v2, int f1) {
            this(v1, v2, f1, -1);
        }

        public Winged(int v1, int v2, int f1, int f2) {
            super(v1, v2);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public String toString() {
            return "(v1=" + this.v1 + ",v2=" + this.v2 + ",f1=" + this.f1 + ",f2=" + this.f2 + ")";
        }
    }
}

