/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

public class DoubleVectorList {
    double[][] data;
    int size;
    final int dim;

    public DoubleVectorList(int dim, int capacity) {
        this.data = new double[capacity][dim];
        this.size = 0;
        this.dim = dim;
    }

    public DoubleVectorList(int dim) {
        this(dim, 100);
    }

    public DoubleVectorList(double[][] data) {
        this.size = data.length;
        this.dim = data[0].length;
        this.data = new double[data.length + (data.length + 10) / 2][this.dim];
        System.arraycopy(data, 0, this.data, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.data.length;
    }

    public double[] get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.data[index];
    }

    public double[] getNewLast() {
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        return this.data[this.size++];
    }

    public void set(int index, double[] value) {
        if (index < 0 || index > this.size || value.length != this.dim) {
            throw new IllegalArgumentException("index out of range");
        }
        if (value.length != this.dim) {
            throw new IllegalArgumentException("vector has wrong dimension");
        }
        if (this.size == index) {
            if (this.size == this.data.length) {
                this.setCapacity(this.data.length + (this.data.length + 10) / 2);
            }
            this.data[this.size++] = value;
        }
        this.data[index] = value;
    }

    public void add(double[] value) {
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        this.data[this.size++] = value;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        this.data[this.data.length - 1] = new double[this.dim];
        --this.size;
    }

    public void insert(int index, double[] value) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (value.length != this.dim) {
            throw new IllegalArgumentException("vector has wrong dimension");
        }
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
    }

    public void setCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException("capacity must exeed size of list");
        }
        double[][] newData = new double[capacity][];
        System.arraycopy(this.data, 0, newData, 0, Math.min(newData.length, this.data.length));
        int i = this.data.length;
        while (i < newData.length) {
            newData[i] = new double[this.dim];
            ++i;
        }
        this.data = newData;
    }

    public void removeAll() {
        this.size = 0;
    }

    void appendVector(double[] vector, StringBuffer sb) {
        sb.append("(");
        if (this.size > 0) {
            sb.append(this.data[0]);
            int j = 1;
            while (j < this.size) {
                sb.append(", ");
                sb.append(this.data[j]);
                ++j;
            }
        }
        sb.append(')');
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("(");
        if (this.size > 0) {
            sb.append(this.data[0]);
            int j = 1;
            while (j < this.size) {
                sb.append(", ");
                this.appendVector(this.data[j], sb);
                ++j;
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

