/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Tridiagonal {
    private Tridiagonal() {
    }

    public static void transform(double[][] A, double[][] Q, double[] d, double[] e) {
        int l;
        int i;
        int n = A.length;
        if (A != Q) {
            i = 0;
            while (i < n) {
                System.arraycopy(A[i], 0, Q[i], 0, n);
                ++i;
            }
        }
        i = n - 1;
        while (i >= 1) {
            l = i - 1;
            double h = 0.0;
            if (l > 1) {
                double scale = 0.0;
                int k = 0;
                while (k <= l) {
                    scale += Math.abs(Q[i][k]);
                    ++k;
                }
                if (scale == 0.0) {
                    e[i] = Q[i][l];
                } else {
                    k = 0;
                    while (k <= l) {
                        double[] dArray = Q[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += Q[i][k] * Q[i][k];
                        ++k;
                    }
                    double f = Q[i][l];
                    double g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    e[i] = scale * g;
                    Q[i][l] = f - g;
                    h -= f * g;
                    double a = 0.0;
                    int j = 0;
                    while (j <= l) {
                        Q[j][i] = Q[i][j] / h;
                        double b = 0.0;
                        int k2 = 0;
                        while (k2 <= j) {
                            b += Q[j][k2] * Q[i][k2];
                            ++k2;
                        }
                        k2 = j + 1;
                        while (k2 <= l) {
                            b += Q[k2][j] * Q[i][k2];
                            ++k2;
                        }
                        e[j] = b / h;
                        a += e[j] * Q[i][j];
                        ++j;
                    }
                    double aBy2h = a / (h + h);
                    int j2 = 0;
                    while (j2 <= l) {
                        double b = Q[i][j2];
                        int n3 = j2;
                        double d2 = e[n3] - aBy2h * b;
                        e[n3] = d2;
                        double c = d2;
                        int k3 = 0;
                        while (k3 <= j2) {
                            double[] dArray = Q[j2];
                            int n4 = k3;
                            dArray[n4] = dArray[n4] - (b * e[k3] + c * Q[i][k3]);
                            ++k3;
                        }
                        ++j2;
                    }
                }
            } else {
                e[i] = Q[i][l];
            }
            d[i] = h;
            --i;
        }
        d[1] = 0.0;
        e[1] = 0.0;
        i = 0;
        while (i < n) {
            l = i - 1;
            if (d[i] != 0.0) {
                int j = 0;
                while (j <= l) {
                    double g = 0.0;
                    int k = 0;
                    while (k <= l) {
                        g += Q[i][k] * Q[k][j];
                        ++k;
                    }
                    k = 0;
                    while (k <= l) {
                        double[] dArray = Q[k];
                        int n5 = j;
                        dArray[n5] = dArray[n5] - g * Q[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            d[i] = Q[i][i];
            Q[i][i] = 1.0;
            int j = 0;
            while (j <= l) {
                Q[i][j] = 0.0;
                Q[j][i] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public static void transform(double[][] A, double[][] Q, double[][] T) {
        double[] d = T[0];
        double[] e = T[1];
        Tridiagonal.transform(A, Q, d, e);
        int n = A.length;
        T[1][0] = e[1];
        T[1][1] = d[1];
        T[0][1] = T[1][0];
        int i = 2;
        while (i < n) {
            T[i][i] = d[i];
            double d2 = e[i];
            T[i - 1][i] = d2;
            T[i][i - 1] = d2;
            ++i;
        }
        i = 0;
        while (i < n) {
            int k = 0;
            while (k < i - 1) {
                T[i][k] = 0.0;
                ++k;
            }
            k = i + 2;
            while (k < n) {
                T[i][k] = 0.0;
                ++k;
            }
            ++i;
        }
    }
}

