/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Collections;
import java.util.Map;

public class SymmetricShapeEditor extends EditorSpawner {
	
	private static boolean allowNullByDefault;
	
	public SymmetricShapeEditor() {
		this(allowNullByDefault);
	}
	
	public SymmetricShapeEditor(boolean withNullOption) {
		super(withNullOption);
	}
	
	public static class WithNullOption extends SymmetricShapeEditor {
		public WithNullOption() {
			super(true);
		}
	}
	
	public AbstractDialog getDialog() {
		return SymmetricShapeChooser.sharedInstance();
	}
	
	protected void paintEditedObject(Component cmp, Graphics g, int x, int y) {
		final Map<RenderingHints.Key,?> hints = Collections.singletonMap(
				RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON
		);
		if (getValue() != null) {
			Graphics2D g2d = (Graphics2D) g;
			g2d.setColor(Color.black);
			g2d.addRenderingHints(hints);
			g2d.translate(x+getIconWidth()/2, y+getIconHeight()/2);
			g2d.fill((Shape)getValue());
			g2d.translate(-(x+getIconWidth()/2), -(y+getIconHeight()/2));
		}
	}

	public boolean accept(Component c, Object o) {
		return SymmetricShapeChooser.sharedInstance().accept(c,o);
	}

	public static boolean isAllowNullByDefault() {
		return allowNullByDefault;
	}

	public static void setAllowNullByDefault(boolean allowNullByDefault) {
		SymmetricShapeEditor.allowNullByDefault = allowNullByDefault;
	}
}
