/*
 * Decompiled with CFR 0.152.
 */
package de.smrj;

import de.smrj.RemoteCall;
import de.smrj.RemoteFactory;
import de.smrj.RemoteObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public abstract class Broadcaster {
    private RemoteFactory remoteFactory;
    public static final int RESPONSE_TYPE_NONE = 0;
    public static final int RESPONSE_TYPE_EXCEPTION = 1;
    public static final int RESPONSE_TYPE_ALL = 2;
    private final int responseType;

    public Broadcaster() {
        this(1);
    }

    public Broadcaster(int type) {
        this.responseType = type;
        this.remoteFactory = new RemoteFactory(this);
    }

    public RemoteFactory getRemoteFactory() {
        return this.remoteFactory;
    }

    protected abstract Object executeRemoteCall(RemoteCall var1) throws IOException;

    protected final ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return new RemoteObjectOutputStream(out, this.getRemoteFactory());
    }

    public void dispose() {
        this.getRemoteFactory().dispose();
    }

    public final int getResponseType() {
        return this.responseType;
    }

    public abstract int getNumClients();
}

