/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.widget;

import de.jtem.jrworkspace.logging.LoggingSystem;
import de.jtem.jrworkspace.plugin.flavor.OpenAboutFlavor;
import de.jtem.jrworkspace.plugin.flavor.OpenPreferencesFlavor;
import de.jtem.jrworkspace.plugin.flavor.ShutdownFlavor;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.AppleApplicationPlugin;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.MockAppleApplication;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class AppleApplicationPluginTest {
    private static ByteArrayOutputStream testOut = new ByteArrayOutputStream();

    @Test
    public void failCreateNoClass() {
        AppleApplicationPlugin.APPLE_APPLICATION_CLASS = "does.not.exist.Class";
        new AppleApplicationPlugin();
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)AppleApplicationPlugin.APPLE_APPLICATION_CLASS));
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"Could not"));
    }

    @Test
    public void createWithExistingClass() {
        new AppleApplicationPlugin();
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"de.jtem.jrworkspace.plugin.simplecontroller.widget.MockAppleApplication addApplicationListener"));
    }

    @Test
    public void addMenuItems() {
        new AppleApplicationPlugin();
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"de.jtem.jrworkspace.plugin.simplecontroller.widget.MockAppleApplication addPreferencesMenuItem"));
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"de.jtem.jrworkspace.plugin.simplecontroller.widget.MockAppleApplication addAboutMenuItem"));
    }

    @Test
    public void shutdown() {
        LoggingSystem.LOGGER.setLevel(Level.INFO);
        AppleApplicationPlugin p = new AppleApplicationPlugin();
        p.setShutdownListener(new ShutdownFlavor.ShutdownListener(){

            @Override
            public void shutdown() {
                LoggingSystem.LOGGER.info("shutdown called");
            }
        });
        ((MockAppleApplication)p.getAppleApplication()).callHandleQuitOnListener();
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"shutdown called"));
    }

    @Test
    public void openAbout() {
        LoggingSystem.LOGGER.setLevel(Level.INFO);
        AppleApplicationPlugin p = new AppleApplicationPlugin();
        p.setOpenAboutListener(new OpenAboutFlavor.OpenAboutListener(){

            @Override
            public void openAboutWindow() {
                LoggingSystem.LOGGER.info("about called");
            }
        });
        ((MockAppleApplication)p.getAppleApplication()).callHandleAboutOnListener();
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"about called"));
    }

    @Test
    public void openPreferences() {
        LoggingSystem.LOGGER.setLevel(Level.INFO);
        AppleApplicationPlugin p = new AppleApplicationPlugin();
        p.setOpenPreferencesListener(new OpenPreferencesFlavor.OpenPreferencesListener(){

            @Override
            public void openPreferencesWindow() {
                LoggingSystem.LOGGER.info("preferences called");
            }
        });
        ((MockAppleApplication)p.getAppleApplication()).callHandlePreferencesOnListener();
        Assert.assertThat((Object)testOut.toString(), (Matcher)JUnitMatchers.containsString((String)"preferences called"));
    }

    @Test
    public void callHandlersWithoutListenersShouldFailQuietly() {
        LoggingSystem.LOGGER.setLevel(Level.INFO);
        AppleApplicationPlugin p = new AppleApplicationPlugin();
        ((MockAppleApplication)p.getAppleApplication()).callHandlePreferencesOnListener();
        ((MockAppleApplication)p.getAppleApplication()).callHandleAboutOnListener();
        ((MockAppleApplication)p.getAppleApplication()).callHandleQuitOnListener();
    }

    @BeforeClass
    public static void addTestHandler() {
        StreamHandler testHandler = new StreamHandler(testOut, new SimpleFormatter()){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        testHandler.setLevel(Level.ALL);
        LoggingSystem.LOGGER.addHandler(testHandler);
    }

    @Before
    public void resetTestOut() {
        LoggingSystem.LOGGER.setLevel(Level.FINEST);
        testOut.reset();
    }

    @Before
    public void setMockClasses() {
        AppleApplicationPlugin.APPLE_APPLICATION_CLASS = "de.jtem.jrworkspace.plugin.simplecontroller.widget.MockAppleApplication";
        AppleApplicationPlugin.APPLE_APPLICATION_LISTENER = "de.jtem.jrworkspace.plugin.simplecontroller.widget.MockAppleApplicationListener";
    }
}

