/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.image;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageHook {
    public static void setIconImage(Dialog dialog, Image image) {
        Class<?> dialogClass = dialog.getClass();
        try {
            Method setMethod = dialogClass.getMethod("setIconImage", Image.class);
            setMethod.invoke((Object)dialog, image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setIconImage(Frame dialog, Image image) {
        Class<?> dialogClass = dialog.getClass();
        try {
            Method setMethod = dialogClass.getMethod("setIconImage", Image.class);
            setMethod.invoke((Object)dialog, image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Image toImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            return imageIcon.getImage();
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        return image;
    }

    public static Image getImage(String filename) {
        InputStream in = ImageHook.class.getResourceAsStream(filename);
        if (in == null) {
            return null;
        }
        BufferedImage result = null;
        try {
            result = ImageIO.read(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Image getImage(String filename, int width, int height) {
        Image image = ImageHook.getImage(filename);
        if (image == null) {
            return null;
        }
        return image.getScaledInstance(width, height, 4);
    }

    public static Icon getIcon(String filename) {
        Image image = ImageHook.getImage(filename);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Icon getIcon(String filename, int width, int height) {
        Image image = ImageHook.getImage(filename, width, height);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Image renderIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        return image;
    }

    public static Icon scaleIcon(Icon icon, int width, int height) {
        if (icon == null) {
            return null;
        }
        Image imageNewSize = null;
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            imageNewSize = imageIcon.getImage().getScaledInstance(width, height, 4);
        } else {
            Image image = ImageHook.renderIcon(icon);
            imageNewSize = ImageHook.scaleImage(image, width, height);
        }
        return new ImageIcon(imageNewSize);
    }

    public static Image scaleImage(Image image, int width, int height) {
        return image.getScaledInstance(4, width, height);
    }
}

