/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import de.jtem.jrworkspace.logging.LoggingSystem;
import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.PluginNameComparator;
import de.jtem.jrworkspace.plugin.flavor.FrontendFlavor;
import de.jtem.jrworkspace.plugin.flavor.HelpFlavor;
import de.jtem.jrworkspace.plugin.flavor.MenuFlavor;
import de.jtem.jrworkspace.plugin.flavor.OpenAboutFlavor;
import de.jtem.jrworkspace.plugin.flavor.OpenPreferencesFlavor;
import de.jtem.jrworkspace.plugin.flavor.PerspectiveFlavor;
import de.jtem.jrworkspace.plugin.flavor.PreferencesFlavor;
import de.jtem.jrworkspace.plugin.flavor.PropertiesFlavor;
import de.jtem.jrworkspace.plugin.flavor.ShutdownFlavor;
import de.jtem.jrworkspace.plugin.flavor.StatusFlavor;
import de.jtem.jrworkspace.plugin.flavor.ToolBarFlavor;
import de.jtem.jrworkspace.plugin.flavor.UIFlavor;
import de.jtem.jrworkspace.plugin.simplecontroller.StartupChain;
import de.jtem.jrworkspace.plugin.simplecontroller.action.AboutAction;
import de.jtem.jrworkspace.plugin.simplecontroller.action.HelpWindowAction;
import de.jtem.jrworkspace.plugin.simplecontroller.action.PreferencesWindowAction;
import de.jtem.jrworkspace.plugin.simplecontroller.help.HelpWindow;
import de.jtem.jrworkspace.plugin.simplecontroller.image.ImageHook;
import de.jtem.jrworkspace.plugin.simplecontroller.preferences.PreferencesWindow;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.AboutDialog;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.SaveOnExitDialog;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.SplashScreen;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SimpleController
implements Controller {
    protected String name = "Simple Controller";
    protected Set<Plugin> plugins = new TreeSet<Plugin>(new PluginNameComparator());
    protected Stack<Plugin> dependencyStack = new Stack();
    protected Set<Class<? extends Plugin>> installed = new HashSet<Class<? extends Plugin>>();
    protected HashMap<String, Object> properties = new HashMap();
    private boolean propertiesAreSafe = false;
    protected PerspectiveFlavor perspective = null;
    protected FlavorListener flavorListener = new FlavorListener();
    protected JFrame mainWindow = null;
    protected Frame fullScreenFrame = null;
    protected SplashScreen splashScreen = null;
    protected HelpWindow helpWindow = null;
    protected HelpWindowAction helpWindowAction = null;
    protected PreferencesWindow preferencesWindow = null;
    protected AboutDialog aboutDialog = null;
    protected JPanel centerPanel = new JPanel();
    protected JPanel toolBarPanel = new JPanel();
    protected JLabel statusLabel = new JLabel("Ready");
    protected boolean hasMainWindow = false;
    protected boolean hasMenuBar = false;
    protected boolean hasToolBar = false;
    protected boolean hasStatusBar = false;
    protected boolean hasHelpMenu = false;
    protected boolean hasPreferencesMenu = false;
    protected boolean localStartup = false;
    protected boolean registerSPIPlugins = true;
    protected boolean manageLookAndFeel = true;
    protected boolean useExternalHelpBrowser = false;
    protected Status status = Status.PreStartup;
    protected XStream propertyxStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
    protected File propFile = null;
    protected InputStream propInputStream = null;
    protected Preferences userPreferences = null;
    protected File staticPropertiesFile = null;
    protected PropertiesMode propertiesMode = PropertiesMode.UserPropertiesFile;
    protected static boolean DEFAULT_SAVE_ON_EXIT = true;
    protected static boolean DEFAULT_ASK_BEFORE_SAVE_ON_EXIT = true;
    protected static boolean DEFAULT_LOAD_FROM_USER_PROPERTY_FILE = true;
    protected static String DEFAULT_USER_PROPERTY_FILE = null;
    protected static int DEFAULT_NB_OF_PROPERY_FILE_BACKUPS = 1;
    private boolean propertyEngineEnabled = true;
    private boolean saveOnExit = DEFAULT_SAVE_ON_EXIT;
    private boolean askBeforeSaveOnExit = DEFAULT_ASK_BEFORE_SAVE_ON_EXIT;
    private boolean loadFromUserPropertyFile = DEFAULT_LOAD_FROM_USER_PROPERTY_FILE;
    private String userPropertyFile = DEFAULT_USER_PROPERTY_FILE;
    private int nbOfPropertyFileBackups = DEFAULT_NB_OF_PROPERY_FILE_BACKUPS;

    public SimpleController() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "SimpleController");
        String filename = null;
        try {
            String userHome = System.getProperty("user.home");
            filename = String.valueOf(userHome) + "/.jrworkspace/default_simple.xml";
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setPropertiesFile(filename == null ? null : new File(filename));
        this.userPreferences = Preferences.userNodeForPackage(this.getClass());
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "SimpleController");
        this.setupAppleHandlers();
    }

    public SimpleController(String name) {
        this();
        this.name = name;
    }

    private void setupAppleHandlers() {
        try {
            Class<?> app = Class.forName("com.apple.eawt.Application");
            Class<?> quit = Class.forName("com.apple.eawt.QuitStrategy");
            Method getAppMethod = app.getMethod("getApplication", new Class[0]);
            Method setQuitMethod = app.getMethod("setQuitStrategy", quit);
            Method valueOfMethod = quit.getMethod("valueOf", String.class);
            Object closeAllStrategy = valueOfMethod.invoke(quit, "CLOSE_ALL_WINDOWS");
            Object appObject = getAppMethod.invoke(app, new Object[0]);
            setQuitMethod.invoke(appObject, closeAllStrategy);
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.info("could not setup mac os handlers, may be not on a mac.");
            return;
        }
    }

    public String toString() {
        return this.name;
    }

    public void registerPlugin(Plugin p) {
        this.plugins.add(p);
        this.setSplashStatus(p.getClass().getSimpleName());
    }

    public void registerPlugin(Class<? extends Plugin> pClass) {
        Plugin p = null;
        try {
            p = pClass.newInstance();
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.severe(e.toString());
            e.printStackTrace();
            return;
        }
        this.plugins.add(p);
        this.setSplashStatus(p.getClass().getSimpleName());
    }

    public void startup() {
        Runnable jobLoadProperties = new Runnable(){

            @Override
            public void run() {
                LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "startup");
                SimpleController.this.setSplashStatus("loading properties");
                SimpleController.this.status = Status.Starting;
                SimpleController.this.registerSPIPlugins();
                SimpleController.this.readUserPreferences();
                SimpleController.this.loadProperties();
            }
        };
        Runnable jobInitialize = new Runnable(){

            @Override
            public void run() {
                SimpleController.this.setSplashStatus("initializing components");
                if (SimpleController.this.manageLookAndFeel) {
                    try {
                        String defaultLnF = "cross_platform_lnf_classname";
                        String lnfClass = SimpleController.this.getProperty(SimpleController.class, "lookAndFeelClass", defaultLnF);
                        SimpleController.this.flavorListener.installLookAndFeel(lnfClass);
                    }
                    catch (Exception e) {
                        LoggingSystem.LOGGER.warning("Could not load look and feel.");
                    }
                }
                SimpleController.this.initializeComponents();
            }
        };
        StartupChain initChain = new StartupChain();
        initChain.appendJob(jobLoadProperties);
        initChain.appendJob(jobInitialize);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                LoggingSystem.LOGGER.finer("start initialization directly on the event dispatch thread");
                initChain.startDirect();
            } else {
                LoggingSystem.LOGGER.finer("start initialization on the event dispatch thread and wait for completion");
                initChain.startQueuedAndWait();
            }
        }
        catch (Exception e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            LoggingSystem.LOGGER.severe(stackTrace.toString());
        }
        LinkedList<Runnable> activateJobs = new LinkedList<Runnable>();
        for (final Plugin p : new LinkedList<Plugin>(this.plugins)) {
            Runnable activationJob = new Runnable(){

                @Override
                public void run() {
                    SimpleController.this.activatePlugin(p);
                }
            };
            activateJobs.add(activationJob);
        }
        Runnable jobFinalize = new Runnable(){

            @Override
            public void run() {
                SimpleController.this.setSplashStatus("completing startup");
                SimpleController.this.status = Status.Started;
                if (SimpleController.this.hasToolBar || SimpleController.this.hasMenuBar) {
                    if (SimpleController.this.perspective == null) {
                        LoggingSystem.LOGGER.severe("SimpleController: No main perspective flavor found. Exit.");
                        System.exit(-1);
                    }
                    if (SimpleController.this.hasMenuBar) {
                        SimpleController.this.updateMenuBarInternal();
                    }
                    if (SimpleController.this.hasToolBar) {
                        SimpleController.this.updateToolBarInternal();
                    }
                }
                if (SimpleController.this.mainWindow != null) {
                    if (!SimpleController.this.localStartup) {
                        Dimension prefSize = SimpleController.this.perspective.getCenterComponent().getPreferredSize();
                        Dimension size = SimpleController.this.getProperty(SimpleController.class, "mainWindowSize", prefSize);
                        SimpleController.this.mainWindow.setSize(size);
                        SimpleController.this.mainWindow.setExtendedState(SimpleController.this.getProperty(SimpleController.class, "mainWindowState", SimpleController.this.mainWindow.getExtendedState()));
                        SimpleController.this.mainWindow.setVisible(true);
                        LoggingSystem.LOGGER.finer("mainWindow visible");
                    }
                    if (SimpleController.this.manageLookAndFeel) {
                        try {
                            String defaultLnF = "cross_platform_lnf_classname";
                            String lnfClass = SimpleController.this.getProperty(SimpleController.class, "lookAndFeelClass", defaultLnF);
                            SimpleController.this.flavorListener.installLookAndFeel(lnfClass);
                            SimpleController.this.flavorListener.updateFrontendUI();
                        }
                        catch (Exception e) {
                            LoggingSystem.LOGGER.config("Could not load look and feel.");
                        }
                    } else {
                        SwingUtilities.updateComponentTreeUI(SimpleController.this.mainWindow);
                    }
                }
            }
        };
        Runnable jobReady = new Runnable(){

            @Override
            public void run() {
                SimpleController.this.setSplashStatus("ready");
                LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "startup");
            }
        };
        StartupChain startupChain = new StartupChain();
        startupChain.appendAll(activateJobs);
        startupChain.appendJob(jobFinalize);
        startupChain.appendJob(jobReady);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                LoggingSystem.LOGGER.finer("startup directly on the event dispatch thread");
                startupChain.startDirect();
            } else {
                LoggingSystem.LOGGER.finer("startup on the event dispatch thread and wait for completion");
                startupChain.startQueuedAndWait();
            }
        }
        catch (Exception e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            LoggingSystem.LOGGER.severe(stackTrace.toString());
        }
    }

    public JRootPane startupLocal() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "startupLocal");
        this.localStartup = true;
        this.startup();
        if (this.mainWindow != null) {
            LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "startupLocal", this.mainWindow.getRootPane());
            return this.mainWindow.getRootPane();
        }
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "startupLocal", "a brand new JRootPane");
        return new JRootPane();
    }

    private void registerSPIPlugins() {
        if (!this.registerSPIPlugins) {
            return;
        }
        Class<?> slClass = null;
        try {
            slClass = Class.forName("java.util.ServiceLoader");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            Method loadMethod = slClass.getMethod("load", Class.class, ClassLoader.class);
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader pluginLoader = new ClassLoader(contextLoader){};
            Iterable loader = (Iterable)loadMethod.invoke(slClass, Plugin.class, pluginLoader);
            for (Plugin p : loader) {
                this.registerPlugin(p);
            }
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.warning("Error while loading SPI plugins: " + e.getLocalizedMessage());
        }
    }

    protected void initializeComponents() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "initializeComponents");
        for (Plugin p : this.plugins) {
            if (p instanceof PerspectiveFlavor) {
                this.perspective = (PerspectiveFlavor)((Object)p);
                this.hasMainWindow = true;
            }
            if (p instanceof HelpFlavor) {
                this.hasHelpMenu = true;
                this.hasMenuBar = true;
                this.hasMainWindow = true;
            }
            if (p instanceof PreferencesFlavor) {
                this.hasPreferencesMenu = true;
                this.hasMenuBar = true;
                this.hasMainWindow = true;
            }
            if (p instanceof ToolBarFlavor) {
                this.hasToolBar = true;
                this.hasMainWindow = true;
            }
            if (p instanceof MenuFlavor) {
                this.hasMenuBar = true;
                this.hasMainWindow = true;
            }
            if (!(p instanceof StatusFlavor)) continue;
            this.hasStatusBar = true;
            this.hasMainWindow = true;
        }
        if (this.hasMainWindow && this.mainWindow == null) {
            this.mainWindow = new JFrame();
            this.mainWindow.setDefaultCloseOperation(0);
            this.mainWindow.setLayout(new BorderLayout());
            this.mainWindow.add((Component)this.centerPanel, "Center");
            if (!this.localStartup) {
                this.mainWindow.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SimpleController.this.shutdown();
                    }
                });
            }
        }
        if (this.hasHelpMenu && this.helpWindow == null) {
            this.helpWindow = new HelpWindow(this.mainWindow);
            this.helpWindow.setLocationByPlatform(true);
            this.helpWindowAction = new HelpWindowAction(this.helpWindow);
        }
        if (this.hasPreferencesMenu && this.preferencesWindow == null) {
            this.preferencesWindow = new PreferencesWindow(this.mainWindow);
            this.preferencesWindow.setLocationByPlatform(true);
        }
        if (this.hasToolBar && this.mainWindow != null) {
            this.toolBarPanel.setLayout(new WrapLayout(3, 0, 0));
            this.mainWindow.remove(this.toolBarPanel);
            this.mainWindow.add((Component)this.toolBarPanel, "North");
        }
        if (this.hasStatusBar && this.mainWindow != null) {
            this.mainWindow.remove(this.statusLabel);
            this.mainWindow.add((Component)this.statusLabel, "South");
        }
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "initializeComponents");
    }

    protected void activatePlugin(Plugin p) {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "activatePlugin", new Object[]{p});
        this.setSplashStatus(p.getClass().getSimpleName());
        if (this.isActive(p)) {
            return;
        }
        this.installed.add(p.getClass());
        this.dependencyStack.push(p);
        try {
            p.restoreStates(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (p instanceof FrontendFlavor) {
            ((FrontendFlavor)((Object)p)).setFrontendListener(this.flavorListener);
        }
        if (p instanceof StatusFlavor) {
            ((StatusFlavor)((Object)p)).setStatusListener(this.flavorListener);
        }
        if (p instanceof HelpFlavor) {
            ((HelpFlavor)((Object)p)).setHelpListener(this.flavorListener);
        }
        if (p instanceof PropertiesFlavor) {
            ((PropertiesFlavor)((Object)p)).setPropertiesListener(this.flavorListener);
        }
        if (p instanceof ShutdownFlavor) {
            ((ShutdownFlavor)((Object)p)).setShutdownListener(this.flavorListener);
        }
        if (p instanceof OpenAboutFlavor) {
            ((OpenAboutFlavor)((Object)p)).setOpenAboutListener(this.flavorListener);
        }
        if (p instanceof OpenPreferencesFlavor) {
            ((OpenPreferencesFlavor)((Object)p)).setOpenPreferencesListener(this.flavorListener);
        }
        try {
            LoggingSystem.LOGGER.fine("installing plugin " + p.getClass().getResource(String.valueOf(p.getClass().getSimpleName()) + ".class"));
            p.install(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dependencyStack.pop();
        if (p instanceof PerspectiveFlavor) {
            this.updateMainWindow();
        }
        if (p instanceof HelpFlavor) {
            HelpFlavor hf = (HelpFlavor)((Object)p);
            this.helpWindow.addHelpPlugin(hf);
            this.updateMenuBarInternal();
        }
        if (p instanceof PreferencesFlavor) {
            this.preferencesWindow.addPreferencesPlugin((PreferencesFlavor)((Object)p));
            this.updateMenuBarInternal();
        }
        if (p instanceof ToolBarFlavor) {
            this.updateToolBarInternal();
        }
        if (p instanceof MenuFlavor) {
            this.updateMenuBarInternal();
        }
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "activatePlugin");
    }

    @Override
    public <T extends Plugin> T getPlugin(Class<T> clazz) {
        for (Plugin p : new LinkedList<Plugin>(this.plugins)) {
            if (!p.getClass().equals(clazz)) continue;
            if (this.status == Status.Starting && !this.isActive(p)) {
                try {
                    this.activatePlugin(p);
                }
                catch (Exception e) {
                    LoggingSystem.LOGGER.warning("could not install dependent plug-in: " + p);
                }
            }
            return (T)((Plugin)clazz.cast(p));
        }
        if (this.status == Status.Starting) {
            Plugin p;
            p = null;
            try {
                p = (Plugin)clazz.newInstance();
            }
            catch (Exception e) {
                LoggingSystem.LOGGER.warning("could not instantiate dependent plug-in: " + clazz.getSimpleName() + ": " + e.getClass().getSimpleName());
                return null;
            }
            this.registerPlugin(p);
            this.initializeComponents();
            try {
                this.activatePlugin(p);
            }
            catch (Exception e) {
                LoggingSystem.LOGGER.warning("could not install dependent plug-in \"" + p + "\" exceptiion: " + e.getClass().getSimpleName());
            }
            return (T)((Plugin)clazz.cast(p));
        }
        throw new RuntimeException("SimpleController: plug-in " + clazz.getSimpleName() + " not found.");
    }

    @Override
    public <T> List<T> getPlugins(Class<T> clazz) {
        LinkedList<Class> classList = new LinkedList<Class>();
        for (Plugin p : this.plugins) {
            if (!clazz.isAssignableFrom(p.getClass())) continue;
            classList.add((Class)clazz.getClass().cast(p.getClass()));
        }
        LinkedList<T> plugins = new LinkedList<T>();
        for (Class c : classList) {
            plugins.add(this.getPlugin(c));
        }
        return plugins;
    }

    @Override
    public <T> T getProperty(Class<?> context, String key, T defaultValue) {
        Object value = this.properties.get(String.valueOf(context.getName()) + ":" + key);
        if (value == null) {
            value = defaultValue;
            this.storeProperty(context, key, value);
        }
        return (T)value;
    }

    @Override
    public Object storeProperty(Class<?> context, String key, Object property) {
        return this.properties.put(String.valueOf(context.getName()) + ":" + key, property);
    }

    @Override
    public <T> T deleteProperty(Class<?> context, String key) {
        return (T)this.properties.remove(String.valueOf(context.getName()) + ":" + key);
    }

    @Override
    public boolean isActive(Plugin p) {
        return this.installed.contains(p.getClass());
    }

    public void setSplashScreen(SplashScreen screen) {
        this.splashScreen = screen;
    }

    public void setSplashStatus(String status) {
        if (this.splashScreen == null) {
            return;
        }
        this.splashScreen.setStatus(status);
        this.updateSplashProgress();
    }

    public void updateSplashProgress() {
        if (this.splashScreen == null) {
            return;
        }
        double progress = (double)this.installed.size() / (double)this.plugins.size();
        this.splashScreen.setProgress(progress);
    }

    protected void updateMainWindow() {
        if (!this.hasMainWindow) {
            return;
        }
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new GridLayout());
        if (this.perspective.getCenterComponent() == null) {
            return;
        }
        this.centerPanel.add(this.perspective.getCenterComponent());
        this.mainWindow.setTitle(this.perspective.getTitle());
        this.mainWindow.setMinimumSize(this.mainWindow.getRootPane().getMinimumSize());
        this.mainWindow.setIconImage(ImageHook.renderIcon(this.perspective.getIcon()));
        if (this.perspective.getIconList() != null) {
            this.mainWindow.setIconImages(this.perspective.getIconList());
        }
    }

    protected void updateMenuBarInternal() {
        if (!this.hasMenuBar || this.status == Status.Starting) {
            return;
        }
        LinkedList<Object> menuList = new LinkedList<Object>();
        for (Plugin mp : new LinkedList<Plugin>(this.plugins)) {
            if (!(mp instanceof MenuFlavor)) continue;
            MenuFlavor mf = (MenuFlavor)((Object)mp);
            this.getPlugin(mf.getPerspective().asSubclass(Plugin.class));
            if (!mf.getPerspective().equals(this.perspective.getClass())) continue;
            menuList.add(mf);
        }
        Collections.sort(menuList, new MenuFlavorComparator());
        JMenuBar mBar = new JMenuBar();
        for (MenuFlavor menuFlavor : menuList) {
            for (JMenu m : menuFlavor.getMenus()) {
                mBar.add(m);
            }
        }
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic('H');
        if (this.hasPreferencesMenu) {
            jMenu.add(new PreferencesWindowAction(this.preferencesWindow));
        }
        if (this.hasHelpMenu) {
            jMenu.add(this.helpWindowAction);
        }
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Frame)this.mainWindow, true);
        }
        jMenu.add(new JPopupMenu.Separator());
        jMenu.add(new AboutAction(this.aboutDialog));
        mBar.add(Box.createHorizontalGlue());
        mBar.add(jMenu);
        JMenuBar oldBar = this.mainWindow.getJMenuBar();
        if (oldBar != null) {
            mBar.setPreferredSize(oldBar.getPreferredSize());
        }
        this.mainWindow.setJMenuBar(mBar);
        mBar.updateUI();
    }

    protected void updateToolBarInternal() {
        if (!this.hasToolBar || this.status == Status.Starting) {
            return;
        }
        this.toolBarPanel.removeAll();
        LinkedList<ToolBarFlavor> toolList = new LinkedList<ToolBarFlavor>();
        for (Plugin p : new LinkedList<Plugin>(this.plugins)) {
            if (!this.isActive(p) || !(p instanceof ToolBarFlavor)) continue;
            ToolBarFlavor tbf = (ToolBarFlavor)((Object)p);
            this.getPlugin(tbf.getPerspective());
            if (!tbf.getPerspective().equals(this.perspective.getClass())) continue;
            toolList.add(tbf);
        }
        Collections.sort(toolList, new ToolBarFlavorComparator());
        for (ToolBarFlavor tbf : toolList) {
            this.toolBarPanel.add(tbf.getToolBarComponent());
        }
        this.mainWindow.doLayout();
    }

    protected void readUserPreferences() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "readUserPreferences");
        if (this.userPreferences == null) {
            return;
        }
        this.saveOnExit = this.userPreferences.getBoolean("saveOnExit", DEFAULT_SAVE_ON_EXIT);
        this.askBeforeSaveOnExit = this.userPreferences.getBoolean("askBeforeSaveOnExit", DEFAULT_ASK_BEFORE_SAVE_ON_EXIT);
        this.loadFromUserPropertyFile = this.userPreferences.getBoolean("loadFromUserPropertyFile", DEFAULT_LOAD_FROM_USER_PROPERTY_FILE);
        this.userPropertyFile = this.userPreferences.get("userPropertyFile", DEFAULT_USER_PROPERTY_FILE);
        LoggingSystem.LOGGER.finer("saveOnExit: " + this.saveOnExit);
        LoggingSystem.LOGGER.finer("askBeforeSaveOnExit: " + this.askBeforeSaveOnExit);
        LoggingSystem.LOGGER.finer("loadFromUserPropertyFile: " + this.loadFromUserPropertyFile);
        LoggingSystem.LOGGER.finer("userPropertyFile: " + this.userPropertyFile);
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "readUserPreferences");
    }

    protected void writeUserPreferences() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "writeUserPreferences");
        if (this.userPreferences == null) {
            return;
        }
        this.userPreferences.putBoolean("saveOnExit", this.saveOnExit);
        this.userPreferences.putBoolean("askBeforeSaveOnExit", this.askBeforeSaveOnExit);
        this.userPreferences.putBoolean("loadFromUserPropertyFile", this.loadFromUserPropertyFile);
        this.userPreferences.put("userPropertyFile", this.userPropertyFile == null ? "" : this.userPropertyFile);
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "writeUserPreferences");
    }

    protected void loadProperties() {
        block28: {
            LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "loadProperties");
            if (!this.propertyEngineEnabled) {
                LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "loadProperties property engine disabled");
                return;
            }
            this.propertiesAreSafe = true;
            InputStream in = null;
            if (this.propertiesMode == PropertiesMode.StaticPropertiesFile) {
                try {
                    in = new FileInputStream(this.staticPropertiesFile);
                    LoggingSystem.LOGGER.finer("reading properties from static properties file " + this.staticPropertiesFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (in == null) {
                    LoggingSystem.LOGGER.warning("static properties file not found " + this.staticPropertiesFile);
                    return;
                }
            } else if (this.loadFromUserPropertyFile) {
                try {
                    in = new FileInputStream(this.userPropertyFile);
                    LoggingSystem.LOGGER.config("userPropertyFile \"" + this.userPropertyFile + "\" used to set input stream");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (in == null) {
                in = this.propInputStream;
                LoggingSystem.LOGGER.config("a property input stream used to get the properties");
            }
            try {
                if (in != null && in.available() == 0) {
                    in = null;
                }
            }
            catch (IOException e) {
                in = null;
            }
            if (in == null && this.propFile != null) {
                try {
                    in = new FileInputStream(this.propFile);
                    LoggingSystem.LOGGER.config("propFile \"" + this.propFile + "\" used");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (in == null) {
                LoggingSystem.LOGGER.finer("no accessible properties File or input stream found");
                return;
            }
            try {
                try {
                    this.properties = (HashMap)this.properties.getClass().cast(this.propertyxStream.fromXML(in));
                }
                catch (Exception e) {
                    LoggingSystem.LOGGER.warning("error while loading properties: " + e.getMessage());
                    this.propertiesAreSafe = false;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LoggingSystem.LOGGER.finer("propertiesAreSafe: " + this.propertiesAreSafe);
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "loadProperties");
    }

    protected boolean savePropertiesOnExit() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "savePropertiesOnExit");
        if (!this.propertyEngineEnabled) {
            LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "savePropertiesOnExit: property engine disabled", true);
            return true;
        }
        LoggingSystem.LOGGER.finer("propertiesAreSafe: " + this.propertiesAreSafe);
        LoggingSystem.LOGGER.finer("askBeforeSaveOnExit: " + this.askBeforeSaveOnExit);
        LoggingSystem.LOGGER.finer("saveOnExit: " + this.saveOnExit);
        if (!this.propertiesAreSafe || !this.askBeforeSaveOnExit && !this.saveOnExit) {
            LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "savePropertiesOnExit", true);
            return true;
        }
        for (Plugin p : this.plugins) {
            try {
                p.storeStates(this);
            }
            catch (Exception e) {
                LoggingSystem.LOGGER.warning("could not store states of plugin \"" + p + "\": " + e.getMessage());
            }
        }
        File file = null;
        if (this.userPropertyFile != null && !this.userPropertyFile.equals("")) {
            file = new File(this.userPropertyFile);
            LoggingSystem.LOGGER.config("userPropertyFile: \"" + this.userPropertyFile + "\"");
        }
        if (file == null) {
            file = this.propFile;
            LoggingSystem.LOGGER.config("propFile: " + (this.propFile == null ? "null" : this.propFile.getAbsolutePath()));
        }
        SaveOnExitDialog dialog = new SaveOnExitDialog(file, this.mainWindow, this);
        if (this.propertiesMode == PropertiesMode.StaticPropertiesFile) {
            LoggingSystem.LOGGER.finer("saving properties to static file " + this.staticPropertiesFile);
            file = this.staticPropertiesFile;
        } else if (this.askBeforeSaveOnExit) {
            boolean canceled;
            boolean bl = canceled = !dialog.show();
            if (canceled) {
                LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "savePropertiesOnExit (property file saving dialog canceled)", false);
                return false;
            }
            file = dialog.getFile();
            LoggingSystem.LOGGER.finer("file obtained from dialog: " + (file == null ? "null" : file.getAbsolutePath()));
        } else {
            try {
                if (file != null && file.getParentFile() != null && !file.getParentFile().exists()) {
                    LoggingSystem.LOGGER.finer("try to make dirs: " + file.getParentFile());
                    file.getParentFile().mkdirs();
                    LoggingSystem.LOGGER.finer("dirs successfully made");
                }
            }
            catch (Exception e) {
                boolean canceled;
                assert (this.saveOnExit);
                LoggingSystem.LOGGER.finer("Although we should not ask the user, we do now, because save on exit was true and we could not save to the given file.");
                boolean bl = canceled = !dialog.show();
                if (canceled) {
                    LoggingSystem.LOGGER.finer("property file saving dialog canceled");
                    LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "savePropertiesOnExit (property file saving dialog canceled)", false);
                    return false;
                }
                file = dialog.getFile();
                LoggingSystem.LOGGER.finer("file obtained from dialog: " + (file == null ? "null" : file.getAbsolutePath()));
            }
        }
        if (file != null) {
            this.backupOldPropertyFiles(file);
            this.writePropertyFile(file);
        }
        try {
            if (this.userPreferences != null) {
                LoggingSystem.LOGGER.finer("flush the user preferences");
                this.userPreferences.flush();
            }
        }
        catch (BackingStoreException e) {
            LoggingSystem.LOGGER.warning("could not persist user preferences: " + e.getMessage());
        }
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "savePropertiesOnExit", true);
        return true;
    }

    protected void backupOldPropertyFiles(File file) {
        if (this.nbOfPropertyFileBackups == 0) {
            return;
        }
        int i = this.nbOfPropertyFileBackups - 1;
        while (i >= 0) {
            File prevBackupFile;
            File backupFile = this.backupFile(file, i);
            if (backupFile.exists()) {
                backupFile.delete();
            }
            if ((prevBackupFile = this.backupFile(file, i - 1)).exists()) {
                prevBackupFile.renameTo(backupFile);
            }
            --i;
        }
        file.renameTo(this.backupFile(file, 0));
    }

    protected File backupFile(File file, int i) {
        String filePathAndStem = file.getAbsolutePath();
        String extension = "";
        int dotPos = filePathAndStem.lastIndexOf(46);
        if (-1 != dotPos) {
            extension = filePathAndStem.substring(dotPos);
            filePathAndStem = filePathAndStem.substring(0, dotPos);
        }
        return new File(String.valueOf(filePathAndStem) + "." + i + extension);
    }

    protected void writePropertyFile(File file) {
        try {
            LoggingSystem.LOGGER.finer("try to write properties to file: " + file);
            String xml = this.propertyxStream.toXML(this.properties);
            LoggingSystem.LOGGER.finest("properties: " + this.properties);
            FileWriter writer = new FileWriter(file);
            writer.write(xml);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            LoggingSystem.LOGGER.warning("writing properties failed to file \"" + file + "\":" + e.getMessage());
        }
    }

    public void setManageLookAndFeel(boolean manageLookAndFeel) {
        this.manageLookAndFeel = manageLookAndFeel;
    }

    public void setShowMenuBar(boolean show) {
        if (this.status != Status.Started) {
            throw new UnsupportedOperationException("Method invocation not supported before startup.");
        }
        this.flavorListener.setShowMenuBar(show);
    }

    public void setShowToolBar(boolean show) {
        if (this.status != Status.Started) {
            throw new UnsupportedOperationException("Method invocation not supported before startup.");
        }
        this.flavorListener.setShowToolBar(show);
    }

    public void setShowStatusBar(boolean show) {
        if (this.status != Status.Started) {
            throw new UnsupportedOperationException("Method invocation not supported before startup.");
        }
        this.flavorListener.setShowStatusBar(show);
    }

    public void setFullscreen(final boolean fs, final boolean exclusive) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SimpleController.this.flavorListener.setFullscreen(fs, exclusive);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPropertiesResource(Class<?> clazz, String propertiesFileName) {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "setPropertiesResource", new Object[]{clazz, propertiesFileName});
        if (clazz != null && propertiesFileName != null) {
            URL url = clazz.getResource(propertiesFileName);
            LoggingSystem.LOGGER.fine("url: " + url);
            if (url != null) {
                File file = new File(url.getFile());
                LoggingSystem.LOGGER.fine("file: " + file);
                if (file.canWrite()) {
                    LoggingSystem.LOGGER.fine("can write to file: " + file);
                    this.setPropertiesFile(file);
                }
                try {
                    this.setPropertiesInputStream(url.openStream());
                }
                catch (IOException e) {
                    LoggingSystem.LOGGER.config("Can not access property resource " + propertiesFileName + " of " + clazz);
                }
            }
        }
        if (clazz != null) {
            this.userPreferences = Preferences.userNodeForPackage(clazz);
            LoggingSystem.LOGGER.fine("userPreferences: " + this.userPreferences);
        } else {
            this.userPreferences = null;
            LoggingSystem.LOGGER.finer("user preferences set to null (disabled)");
        }
        this.readUserPreferences();
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "setPropertiesResource");
    }

    public int getNbOfPropertyFileBackups() {
        return this.nbOfPropertyFileBackups;
    }

    public void setNbOfPropertyFileBackups(int nbOfPropertyFileBackups) {
        this.nbOfPropertyFileBackups = nbOfPropertyFileBackups;
    }

    public void setPropertiesFile(File propertiesFile) {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "setPropertiesFile", new Object[]{propertiesFile});
        this.propFile = propertiesFile;
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "setPropertiesFile");
    }

    public void setPropertiesInputStream(InputStream in) {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "setPropertiesInputStream: " + in);
        this.propInputStream = in;
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "setPropertiesInputStream");
    }

    public void setShowPreferencesWindow(boolean show) {
        if (this.preferencesWindow == null) {
            return;
        }
        if (this.preferencesWindow.isShowing()) {
            this.preferencesWindow.toFront();
            return;
        }
        this.preferencesWindow.setLocationByPlatform(true);
        this.preferencesWindow.setLocationRelativeTo(this.preferencesWindow.getParent());
        this.preferencesWindow.updateData();
        this.preferencesWindow.setVisible(true);
    }

    public boolean isSaveOnExit() {
        return this.saveOnExit;
    }

    public void setSaveOnExit(boolean saveOnExit) {
        this.saveOnExit = saveOnExit;
        this.writeUserPreferences();
    }

    public boolean isAskBeforeSaveOnExit() {
        return this.askBeforeSaveOnExit;
    }

    public void setAskBeforeSaveOnExit(boolean askBeforeSaveOnExit) {
        this.askBeforeSaveOnExit = askBeforeSaveOnExit;
        this.writeUserPreferences();
    }

    public boolean isLoadFromUserPropertyFile() {
        return this.loadFromUserPropertyFile;
    }

    public void setLoadFromUserPropertyFile(boolean loadFromUserPropertyFile) {
        this.loadFromUserPropertyFile = loadFromUserPropertyFile;
        this.writeUserPreferences();
    }

    public String getUserPropertyFile() {
        return this.userPropertyFile;
    }

    public void setUserPropertyFile(String userPropertyFile) {
        this.userPropertyFile = userPropertyFile;
        this.writeUserPreferences();
    }

    public void setPropertiesMode(PropertiesMode preferencesMode) {
        this.propertiesMode = preferencesMode;
    }

    public void setStaticPropertiesFile(File staticPropertiesFile) {
        this.staticPropertiesFile = staticPropertiesFile;
    }

    public boolean isPropertyEngineEnabled() {
        return this.propertyEngineEnabled;
    }

    public void setPropertyEngineEnabled(boolean propertyEngineEnabled) {
        this.propertyEngineEnabled = propertyEngineEnabled;
    }

    public boolean isRegisterSPIPlugins() {
        return this.registerSPIPlugins;
    }

    public void setRegisterSPIPlugins(boolean loadSPIPlugins) {
        this.registerSPIPlugins = loadSPIPlugins;
    }

    public void shutdown() {
        LoggingSystem.LOGGER.entering(SimpleController.class.getName(), "shutdown", new Object[0]);
        Runnable doSaveAndExit = new Runnable(){

            @Override
            public void run() {
                LoggingSystem.LOGGER.entering("doSaveAndExit Runnable", "run (do the save and exit stuff)", new Object[0]);
                if (SimpleController.this.mainWindow != null) {
                    SimpleController.this.storeProperty(SimpleController.class, "mainWindowSize", SimpleController.this.mainWindow.getSize());
                    SimpleController.this.storeProperty(SimpleController.class, "mainWindowState", SimpleController.this.mainWindow.getExtendedState());
                }
                if (SimpleController.this.savePropertiesOnExit()) {
                    SimpleController.this.dispose();
                    LoggingSystem.LOGGER.finer("system exit");
                    System.exit(0);
                }
            }
        };
        LoggingSystem.LOGGER.finer("start a new thread to do save on exit");
        new Thread(doSaveAndExit, this.getClass() + " shutdown").run();
        LoggingSystem.LOGGER.exiting(SimpleController.class.getName(), "shutdown");
    }

    public void dispose() {
        if (this.mainWindow != null) {
            LoggingSystem.LOGGER.finer("dispose main window");
            this.mainWindow.dispose();
            this.mainWindow = null;
        }
        if (this.fullScreenFrame != null) {
            LoggingSystem.LOGGER.finer("dispose full screen");
            this.fullScreenFrame.dispose();
            this.fullScreenFrame = null;
        }
        if (this.helpWindow != null) {
            LoggingSystem.LOGGER.finer("dispose help window");
            this.helpWindow.dispose();
            this.helpWindow = null;
        }
        if (this.aboutDialog != null) {
            LoggingSystem.LOGGER.finer("dispose about dialog");
            this.aboutDialog.dispose();
            this.aboutDialog = null;
        }
        if (this.preferencesWindow != null) {
            LoggingSystem.LOGGER.finer("dispose preferences window");
            this.preferencesWindow.dispose();
            this.preferencesWindow = null;
        }
    }

    protected class FlavorListener
    implements StatusFlavor.StatusChangedListener,
    FrontendFlavor.FrontendListener,
    HelpFlavor.HelpListener,
    PropertiesFlavor.PropertiesListener,
    ShutdownFlavor.ShutdownListener,
    OpenPreferencesFlavor.OpenPreferencesListener,
    OpenAboutFlavor.OpenAboutListener {
        transient Desktop desktop;
        transient Collection<String> urls = new Vector<String>();

        protected FlavorListener() {
        }

        @Override
        public void statusChanged(String status) {
            if (SimpleController.this.statusLabel != null) {
                SimpleController.this.statusLabel.setText(status);
                SimpleController.this.statusLabel.repaint();
            }
        }

        @Override
        public void updateFrontend() {
            if (SimpleController.this.mainWindow == null || SimpleController.this.status != Status.Started) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleController.this.updateMainWindow();
                    FlavorListener.this.updateMenuBar();
                    ((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow.doLayout();
                    if (((FlavorListener)FlavorListener.this).SimpleController.this.preferencesWindow != null) {
                        ((FlavorListener)FlavorListener.this).SimpleController.this.preferencesWindow.doLayout();
                    }
                    if (((FlavorListener)FlavorListener.this).SimpleController.this.helpWindow != null) {
                        ((FlavorListener)FlavorListener.this).SimpleController.this.helpWindow.doLayout();
                    }
                }
            });
        }

        @Override
        public void updateContent() {
            if (SimpleController.this.mainWindow == null || SimpleController.this.status != Status.Started) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleController.this.updateMainWindow();
                    ((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow.doLayout();
                    if (((FlavorListener)FlavorListener.this).SimpleController.this.fullScreenFrame != null) {
                        ((FlavorListener)FlavorListener.this).SimpleController.this.fullScreenFrame.doLayout();
                    }
                }
            });
        }

        @Override
        public void updateMenuBar() {
            if (SimpleController.this.mainWindow == null || SimpleController.this.status != Status.Started) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleController.this.updateMenuBarInternal();
                    ((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow.doLayout();
                    if (((FlavorListener)FlavorListener.this).SimpleController.this.fullScreenFrame != null) {
                        ((FlavorListener)FlavorListener.this).SimpleController.this.fullScreenFrame.doLayout();
                    }
                }
            });
        }

        @Override
        public void updateFrontendUI() {
            if (SimpleController.this.status == Status.Started && SimpleController.this.mainWindow != null && SimpleController.this.mainWindow.isShowing()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.updateComponentTreeUI(((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow);
                        if (((FlavorListener)FlavorListener.this).SimpleController.this.fullScreenFrame != null) {
                            SwingUtilities.updateComponentTreeUI(((FlavorListener)FlavorListener.this).SimpleController.this.fullScreenFrame);
                        }
                        if (((FlavorListener)FlavorListener.this).SimpleController.this.preferencesWindow != null) {
                            SwingUtilities.updateComponentTreeUI(((FlavorListener)FlavorListener.this).SimpleController.this.preferencesWindow);
                        }
                        if (((FlavorListener)FlavorListener.this).SimpleController.this.helpWindow != null) {
                            SwingUtilities.updateComponentTreeUI(((FlavorListener)FlavorListener.this).SimpleController.this.helpWindow);
                        }
                    }
                });
            }
        }

        @Override
        public void installLookAndFeel(String lnfClassName) {
            if (lnfClassName.equals("system_lnf_classname")) {
                lnfClassName = UIManager.getSystemLookAndFeelClassName();
            }
            if (lnfClassName.equals("cross_platform_lnf_classname")) {
                lnfClassName = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lnfClassName);
            }
            catch (Exception e) {
                System.err.println("Cannot install look and feel: " + lnfClassName);
                return;
            }
            for (Plugin p : SimpleController.this.plugins) {
                if (!(p instanceof UIFlavor)) continue;
                ((UIFlavor)((Object)p)).mainUIChanged(lnfClassName);
            }
        }

        @Override
        public void setFullscreen(boolean fs, boolean exclusive) {
            if (SimpleController.this.mainWindow == null) {
                return;
            }
            GraphicsDevice gd = SimpleController.this.mainWindow.getGraphicsConfiguration().getDevice();
            if (!gd.isFullScreenSupported()) {
                return;
            }
            if (fs) {
                Container content = SimpleController.this.mainWindow.getContentPane();
                JMenuBar menuBar = SimpleController.this.mainWindow.getJMenuBar();
                SimpleController.this.mainWindow.setVisible(false);
                SimpleController.this.fullScreenFrame = new Frame(SimpleController.this.mainWindow.getTitle());
                ImageHook.setIconImage(SimpleController.this.fullScreenFrame, SimpleController.this.mainWindow.getIconImage());
                SimpleController.this.fullScreenFrame.setUndecorated(true);
                SimpleController.this.fullScreenFrame.setLayout(new BorderLayout());
                SimpleController.this.fullScreenFrame.add((Component)content, "Center");
                if (menuBar != null) {
                    menuBar.setPreferredSize(new Dimension(10, 0));
                    SimpleController.this.fullScreenFrame.add((Component)menuBar, "North");
                }
                SimpleController.this.mainWindow.dispose();
                if (exclusive) {
                    gd.setFullScreenWindow(SimpleController.this.fullScreenFrame);
                } else {
                    GraphicsDevice[] gs;
                    Rectangle virtualBounds = new Rectangle();
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice[] graphicsDeviceArray = gs = ge.getScreenDevices();
                    int n = gs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GraphicsDevice device = graphicsDeviceArray[n2];
                        GraphicsConfiguration[] gc = device.getConfigurations();
                        int i = 0;
                        while (i < gc.length) {
                            virtualBounds = virtualBounds.union(gc[i].getBounds());
                            ++i;
                        }
                        ++n2;
                    }
                    SimpleController.this.fullScreenFrame.setBounds(virtualBounds);
                    SimpleController.this.fullScreenFrame.setVisible(true);
                }
            } else {
                Component[] c = SimpleController.this.fullScreenFrame.getComponents();
                SimpleController.this.mainWindow.setContentPane((Container)c[0]);
                if (c.length > 1) {
                    SimpleController.this.mainWindow.setJMenuBar((JMenuBar)c[1]);
                }
                gd.setFullScreenWindow(null);
                SimpleController.this.fullScreenFrame.dispose();
                SimpleController.this.mainWindow.setVisible(true);
                SimpleController.this.mainWindow.requestFocus();
            }
        }

        @Override
        public boolean isFullscreen() {
            return SimpleController.this.fullScreenFrame != null && SimpleController.this.fullScreenFrame.isShowing();
        }

        @Override
        public void setShowMenuBar(final boolean show) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow.getJMenuBar() != null) {
                        Dimension d = show ? null : new Dimension(10, 0);
                        ((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow.getJMenuBar().setPreferredSize(d);
                        ((FlavorListener)FlavorListener.this).SimpleController.this.mainWindow.getJMenuBar().revalidate();
                    }
                }
            });
        }

        @Override
        public boolean isShowMenuBar() {
            if (SimpleController.this.mainWindow == null) {
                return false;
            }
            JMenuBar menu = SimpleController.this.mainWindow.getJMenuBar();
            return menu != null && !menu.isPreferredSizeSet();
        }

        @Override
        public void setShowToolBar(final boolean show) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((FlavorListener)FlavorListener.this).SimpleController.this.toolBarPanel.setVisible(show);
                }
            });
        }

        @Override
        public boolean isShowToolBar() {
            return SimpleController.this.toolBarPanel.isVisible();
        }

        @Override
        public void setShowStatusBar(final boolean show) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((FlavorListener)FlavorListener.this).SimpleController.this.statusLabel.setVisible(show);
                }
            });
        }

        @Override
        public boolean isShowStatusBar() {
            return SimpleController.this.statusLabel.isVisible();
        }

        @Override
        public void setTitle(String title) {
            if (SimpleController.this.mainWindow != null) {
                SimpleController.this.mainWindow.setTitle(title);
            }
        }

        @Override
        public void showHelpPage(HelpFlavor hf) {
            String helpresource = hf.getHelpDocument();
            if (SimpleController.this.useExternalHelpBrowser && helpresource.startsWith("http://") || helpresource.startsWith("file://")) {
                System.err.println("Have a URL");
                this.browseDocumentation(helpresource);
            } else if (SimpleController.this.helpWindow != null) {
                SimpleController.this.helpWindow.activateHelpPage(hf);
                SimpleController.this.helpWindowAction.actionPerformed(null);
            }
        }

        public void browseDocumentation(String docName) {
            if (docName == null) {
                return;
            }
            if (this.urls.contains(docName)) {
                System.err.println("URL already open in browser");
                return;
            }
            if (Desktop.isDesktopSupported()) {
                this.desktop = Desktop.getDesktop();
                if (this.desktop != null && this.desktop.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = null;
                    try {
                        if (!docName.startsWith("http") && !docName.startsWith("file")) {
                            throw new IllegalStateException("Can't open resource " + docName);
                        }
                        uri = new URI(docName);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    try {
                        this.desktop.browse(uri);
                        this.urls.add(docName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void readProperties(Reader r) {
            try {
                SimpleController.this.properties = (HashMap)SimpleController.this.propertyxStream.fromXML(r);
            }
            catch (Exception e) {
                LoggingSystem.LOGGER.warning("Could not read properties: " + e.getLocalizedMessage());
                return;
            }
            for (Plugin p : SimpleController.this.plugins) {
                try {
                    p.restoreStates(SimpleController.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void writeProperties(Writer w) {
            for (Plugin p : SimpleController.this.plugins) {
                try {
                    p.storeStates(SimpleController.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            SimpleController.this.propertyxStream.toXML(SimpleController.this.properties, w);
        }

        @Override
        public void loadDefaultProperties() {
            SimpleController.this.properties = new HashMap();
            for (Plugin p : SimpleController.this.plugins) {
                try {
                    p.restoreStates(SimpleController.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public String getUserPropertyFile() {
            return SimpleController.this.getUserPropertyFile();
        }

        @Override
        public boolean isAskBeforeSaveOnExit() {
            return SimpleController.this.isAskBeforeSaveOnExit();
        }

        @Override
        public boolean isLoadFromUserPropertyFile() {
            return SimpleController.this.isLoadFromUserPropertyFile();
        }

        @Override
        public boolean isSaveOnExit() {
            return SimpleController.this.isSaveOnExit();
        }

        @Override
        public void setAskBeforeSaveOnExit(boolean askBeforeSaveOnExit) {
            SimpleController.this.setAskBeforeSaveOnExit(askBeforeSaveOnExit);
        }

        @Override
        public void setLoadFromUserPropertyFile(boolean loadFromUserPropertyFile) {
            SimpleController.this.setLoadFromUserPropertyFile(loadFromUserPropertyFile);
        }

        @Override
        public void setSaveOnExit(boolean saveOnExit) {
            SimpleController.this.setSaveOnExit(saveOnExit);
        }

        @Override
        public void setUserPropertyFile(String userPropertyFile) {
            SimpleController.this.setUserPropertyFile(userPropertyFile);
        }

        @Override
        public void shutdown() {
            SimpleController.this.shutdown();
        }

        @Override
        public void openAboutWindow() {
            SimpleController.this.aboutDialog.showWindow();
        }

        @Override
        public void openPreferencesWindow() {
            SimpleController.this.preferencesWindow.showWindow();
        }
    }

    protected class MenuFlavorComparator
    implements Comparator<MenuFlavor> {
        protected MenuFlavorComparator() {
        }

        @Override
        public int compare(MenuFlavor o1, MenuFlavor o2) {
            return o1.getPriority() < o2.getPriority() ? -1 : 1;
        }
    }

    public static enum PropertiesMode {
        UserPropertiesFile,
        StaticPropertiesFile;

    }

    public static enum Status {
        PreStartup,
        Starting,
        Started;

    }

    protected class ToolBarFlavorComparator
    implements Comparator<ToolBarFlavor> {
        protected ToolBarFlavorComparator() {
        }

        @Override
        public int compare(ToolBarFlavor o1, ToolBarFlavor o2) {
            return o1.getToolBarPriority() < o2.getToolBarPriority() ? -1 : 1;
        }
    }
}

