/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller;

import de.jtem.jrworkspace.junitUtils.NbPlugin;
import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.simplecontroller.SimpleController;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.prefs.Preferences;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class PropertyFilesTest {
    private SimpleController controller;
    private File dir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/BackupTest");
    private File file = new File(String.valueOf(this.dir.getAbsolutePath()) + "/test.xml");
    private NbPlugin nbPlugin;

    @Before
    public void initDir() {
        this.dir.mkdir();
    }

    @After
    public void rmDir() {
        File[] fileArray = this.dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        this.dir.delete();
    }

    @Before
    public void initController() {
        Preferences userPreferences = Preferences.userNodeForPackage(this.getClass());
        userPreferences.put("userPropertyFile", "");
        this.controller = new SimpleController();
        this.controller.setAskBeforeSaveOnExit(false);
        this.controller.setLoadFromUserPropertyFile(false);
        this.controller.setSaveOnExit(true);
        this.controller.setPropertiesFile(this.file);
        this.nbPlugin = new NbPlugin();
        this.controller.registerPlugin((Plugin)this.nbPlugin);
        this.controller.startupLocal();
    }

    @Test
    public void testPropertyFileSaving() throws Exception {
        this.nbPlugin.setNumber(42);
        this.controller.savePropertiesOnExit();
        this.nbPlugin.setNumber(43);
        Assert.assertEquals((long)43L, (long)this.nbPlugin.getNumber());
        this.nbPlugin.restoreStates((Controller)this.controller);
        Assert.assertEquals((long)42L, (long)this.nbPlugin.getNumber());
        this.controller.setLoadFromUserPropertyFile(true);
        this.controller.loadProperties();
        this.nbPlugin.restoreStates((Controller)this.controller);
        Assert.assertEquals((long)42L, (long)this.nbPlugin.getNumber());
    }

    @Test
    public void testNbOfPropertyBackups() throws Exception {
        this.controller.setNbOfPropertyFileBackups(2);
        this.nbPlugin.setNumber(42);
        this.controller.savePropertiesOnExit();
        this.nbPlugin.setNumber(43);
        this.controller.savePropertiesOnExit();
        this.nbPlugin.setNumber(45);
        this.controller.savePropertiesOnExit();
        this.nbPlugin.setNumber(46);
        this.controller.savePropertiesOnExit();
        this.nbPlugin.setNumber(47);
        this.controller.savePropertiesOnExit();
        Assert.assertEquals((long)3L, (long)this.dir.list().length);
        Assert.assertThat((Object)this.backupFileAsString(-1), (Matcher)JUnitMatchers.containsString((String)"<int>47</int>"));
        Assert.assertThat((Object)this.backupFileAsString(0), (Matcher)JUnitMatchers.containsString((String)"<int>46</int>"));
        Assert.assertThat((Object)this.backupFileAsString(1), (Matcher)JUnitMatchers.containsString((String)"<int>45</int>"));
    }

    private String backupFileAsString(int i) throws IOException {
        char[] buffer = new char[1024];
        FileReader reader = null;
        reader = -1 == i ? new FileReader(this.file) : new FileReader(this.controller.backupFile(this.file, i));
        reader.read(buffer);
        reader.close();
        return new String(buffer);
    }
}

