/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.sidecontainer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class SideContainerLayout
extends BorderLayout {
    private static final long serialVersionUID = 1L;
    private Component leftSlot = null;
    private Component rightSlot = null;
    private Component centerPanel = null;

    public SideContainerLayout(Component leftSlot, Component rightSlot, Component centerPanel) {
        this.leftSlot = leftSlot;
        this.rightSlot = rightSlot;
        this.centerPanel = centerPanel;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        this.layoutContainer(target);
        Dimension size = new Dimension();
        if (target.isAncestorOf(this.leftSlot)) {
            size.width += this.leftSlot.getSize().width;
        }
        if (target.isAncestorOf(this.rightSlot)) {
            size.width += this.rightSlot.getSize().width;
        }
        size.width += this.centerPanel.getPreferredSize().width;
        size.height = this.centerPanel.getPreferredSize().height;
        return size;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        this.layoutContainer(target);
        Dimension size = new Dimension();
        if (target.isAncestorOf(this.leftSlot)) {
            size.width += this.leftSlot.getMinimumSize().width;
        }
        if (target.isAncestorOf(this.rightSlot)) {
            size.width += this.rightSlot.getMinimumSize().width;
        }
        size.width += this.centerPanel.getMinimumSize().width;
        size.height = this.centerPanel.getMinimumSize().height;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            if (target.isAncestorOf(this.rightSlot)) {
                int rightWidth = this.rightSlot.getPreferredSize().width;
                if (rightWidth < this.rightSlot.getMinimumSize().width) {
                    rightWidth = this.rightSlot.getMinimumSize().width;
                }
                this.rightSlot.setSize(rightWidth, bottom - top);
                this.rightSlot.setBounds(right - rightWidth, top, rightWidth, bottom - top);
                right -= rightWidth + this.getHgap();
            }
            if (target.isAncestorOf(this.leftSlot)) {
                int leftWidth = this.leftSlot.getPreferredSize().width;
                if (leftWidth < this.leftSlot.getMinimumSize().width) {
                    leftWidth = this.leftSlot.getMinimumSize().width;
                }
                this.leftSlot.setSize(leftWidth, bottom - top);
                this.leftSlot.setBounds(left, top, leftWidth, bottom - top);
                left += leftWidth + this.getHgap();
            }
            this.centerPanel.setSize(right - left, bottom - top);
            this.centerPanel.setBounds(left, top, right - left, bottom - top);
        }
    }
}

