/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Cholesky {
    private static IllegalArgumentException notPositiveDefinte = new IllegalArgumentException("matrix is not positive definite");

    private Cholesky() {
    }

    public static void decompose(double[][] A, double[][] L) {
        int n = A.length;
        int i = 0;
        while (i < n) {
            double[] ithRowOfL = L[i];
            double[] ithRowOfA = A[i];
            int j = i;
            while (j < n) {
                double[] jthRowOfL = L[j];
                double sum = ithRowOfA[j];
                int k = i - 1;
                while (k >= 0) {
                    sum -= ithRowOfL[k] * jthRowOfL[k];
                    --k;
                }
                if (i == j) {
                    if (sum <= 0.0) {
                        throw notPositiveDefinte;
                    }
                    if (L != null) {
                        L[j][i] = Math.sqrt(sum);
                    }
                } else if (L != null) {
                    L[j][i] = sum / L[i][i];
                }
                if (i < j) {
                    L[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public static boolean decomposable(double[][] A, double eps) {
        int n = A.length;
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                if (Math.abs(A[i][j] - A[j][i]) > eps) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        try {
            Cholesky.decompose(A, null);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean decomposable(double[][] A) {
        return Cholesky.decomposable(A, 1.0E-14);
    }
}

