/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.beans.PropertyEditorSupport;
import java.util.HashMap;

public class EnumEditor extends PropertyEditorSupport {

	Class<? extends Enum<?>> clazz;

	HashMap<String, Enum<? extends Enum<?>>> nameToEnum = new HashMap<String, Enum<? extends Enum<?>>>();
	HashMap<Enum<? extends Enum<?>>, String> enumToName = new HashMap<Enum<? extends Enum<?>>, String>();
	
	String[] tags;
	
	public EnumEditor(Class<? extends Enum<?>> clazz) {
		this.clazz=clazz;
		Enum<?>[] stuff = clazz.getEnumConstants();
		tags = new String[stuff.length];
		for (int i = 0; i < stuff.length; i++) {
			Enum<?> e = stuff[i];
			String name = e.name();
			tags[i]=name;
			nameToEnum.put(name, e);
			enumToName.put(e, name);
		}
	}
	
	@Override
	public String[] getTags() {
		return tags;
	}
	
	@Override
	public void setAsText(String text) throws IllegalArgumentException {
		setValue(nameToEnum.get(text));
	}
}
