/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DimensionDialog extends AbstractDialog {
	private static final long serialVersionUID = -7324851351843354074L;
	private static DimensionDialog instance = null;
	private DimensionPanel dimensionPanel;
	private static boolean ok;
	
	public static DimensionDialog sharedInstance() {
		if( instance == null ) {
			instance = new DimensionDialog();
		}
		return instance; 
	}
	
	public DimensionDialog() {
		dimensionPanel = new DimensionPanel();
		dimensionPanel.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				fireStateChanged();
			}
		});
		setMainComponent(dimensionPanel);
		pack();
	}

	public void setValue(Object o) {
		dimensionPanel.setDimension((Dimension) o);
	}

	public Object getValue() {
		return dimensionPanel.getDimension();
	}
	
	public static Dimension selectDimension(Dimension d, Component c) {
		DimensionDialog dialog = sharedInstance();
		dialog.setValue(d);
		dialog.setModal(true);
		dialog.setOkListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ok = true;
			}
		});
		dialog.setCancelListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ok = false;
			}
		});
		dialog.show(c);
		return ok? (Dimension) sharedInstance().getValue() : null;
	}
}
