/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Toolkit;

class CircularBuffer {
    boolean convertSign = false;
    boolean convertByteOrder = false;
    private byte[] array;
    private long bytesWritten = 0L;
    private long bytesRead = 0L;
    private long end = -1L;

    CircularBuffer(int n, boolean bl, boolean bl2) {
        this.array = new byte[n];
        this.convertSign = bl;
        this.convertByteOrder = bl2;
    }

    synchronized int write(byte[] byArray, int n, int n2) {
        int n3;
        if (this.end >= 0L || n2 == 0) {
            return 0;
        }
        int n4 = n3 = Math.min(n2, this.bytesAvailableToWrite());
        while (n4 > 0) {
            int n5 = n4;
            int n6 = this.getWriteIndex();
            n5 = Math.min(n5, this.array.length - n6);
            System.arraycopy(byArray, n, this.array, n6, n5);
            if (this.convertSign) {
                Toolkit.getUnsigned8(this.array, n6, n5);
            } else if (this.convertByteOrder) {
                Toolkit.getByteSwapped(this.array, n6, n5 - n5 % 2);
            }
            this.bytesWritten += (long)n5;
            n4 -= n5;
            n += n5;
        }
        return n3;
    }

    synchronized int read(byte[] byArray, int n, int n2) {
        int n3;
        if (this.end >= 0L && this.bytesRead >= this.bytesWritten) {
            return -1;
        }
        int n4 = n3 = Math.min(n2, this.bytesAvailableToRead());
        while (n4 > 0) {
            int n5 = n4;
            n5 = Math.min(n5, this.array.length - this.getReadIndex());
            System.arraycopy(this.array, this.getReadIndex(), byArray, n, n5);
            this.bytesRead += (long)n5;
            n4 -= n5;
            n += n5;
        }
        return n3;
    }

    synchronized int writeover(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = this.getByteLength();
        if (n2 > n4) {
            n3 = n2 - n4;
            n += n3;
            n2 = n4;
            this.flush();
        } else if (n2 > this.bytesAvailableToWrite()) {
            n3 = n2 - this.bytesAvailableToWrite();
            this.skip(n3);
        }
        this.write(byArray, n, n2);
        return n3;
    }

    synchronized void flush() {
        this.bytesRead = this.bytesWritten;
    }

    void drain() {
        long l = this.bytesWritten;
        int n = 400;
        while (this.bytesRead < l && n-- > 0) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized int skip(int n) {
        int n2 = Math.min(n, this.bytesAvailableToRead());
        this.bytesRead += (long)n2;
        return n2;
    }

    synchronized void markEnd() {
        this.end = this.bytesWritten;
    }

    int bytesAvailableToRead() {
        return (int)(this.bytesWritten - this.bytesRead);
    }

    int bytesAvailableToWrite() {
        return this.end >= 0L ? 0 : this.array.length - this.bytesAvailableToRead();
    }

    int getByteLength() {
        return this.array.length;
    }

    private int getReadIndex() {
        return (int)(this.bytesRead % (long)this.array.length);
    }

    private int getWriteIndex() {
        return (int)(this.bytesWritten % (long)this.array.length);
    }
}

