/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.lnfswitch;

import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.PluginInfo;
import de.jtem.jrworkspace.plugin.PluginNameComparator;
import de.jtem.jrworkspace.plugin.flavor.FrontendFlavor;
import de.jtem.jrworkspace.plugin.flavor.PreferencesFlavor;
import de.jtem.jrworkspace.plugin.lnfswitch.LookAndFeelPlugin;
import de.jtem.jrworkspace.plugin.lnfswitch.image.ImageHook;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelSwitch
extends Plugin
implements PreferencesFlavor,
FrontendFlavor,
ActionListener {
    private OptionsPanel optionsPanel = null;
    private int activeIndex = -1;
    private List<LookAndFeelPlugin> lookAndFeelList = new LinkedList<LookAndFeelPlugin>();
    private FrontendFlavor.FrontendListener frontendListener = null;
    private Controller controller = null;
    private JComboBox lnfComboBox = new JComboBox();
    private JPanel lnfOptionsPanel = new JPanel();

    public LookAndFeelSwitch() {
        this.lnfComboBox.addActionListener(this);
    }

    public void addLookAndFeel(LookAndFeelPlugin lnf) {
        this.lookAndFeelList.add(lnf);
        this.updateFrontend();
    }

    public void removeLookAndFeel(LookAndFeelPlugin lnf) {
        this.lookAndFeelList.remove(lnf);
        this.updateFrontend();
    }

    public void updateLookAndFeel() {
        Object item = this.lnfComboBox.getSelectedItem();
        if (item instanceof LookAndFeelPlugin) {
            LookAndFeelPlugin lnf = (LookAndFeelPlugin)item;
            this.activeIndex = this.lnfComboBox.getSelectedIndex();
            SwitchWorkspaceThread switcher = new SwitchWorkspaceThread(lnf);
            SwingUtilities.invokeLater(switcher);
        }
    }

    private void updateFrontend() {
        this.lnfComboBox.removeActionListener(this);
        Collections.sort(this.lookAndFeelList, new PluginNameComparator());
        this.lnfComboBox.removeAllItems();
        for (LookAndFeelPlugin lnf : this.lookAndFeelList) {
            this.lnfComboBox.addItem(lnf);
        }
        this.lnfOptionsPanel.removeAll();
        if (this.activeIndex < this.lookAndFeelList.size()) {
            LookAndFeelPlugin lnf;
            this.lnfComboBox.setSelectedIndex(this.activeIndex);
            Object lnfObject = this.lnfComboBox.getSelectedItem();
            if (lnfObject != null && (lnf = (LookAndFeelPlugin)lnfObject).getOptionPanel() != null) {
                this.lnfOptionsPanel.add(lnf.getOptionPanel());
            }
        }
        this.lnfOptionsPanel.doLayout();
        this.lnfComboBox.addActionListener(this);
    }

    @Override
    public void setFrontendListener(FrontendFlavor.FrontendListener l) {
        this.frontendListener = l;
    }

    public OptionsPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new OptionsPanel();
        }
        return this.optionsPanel;
    }

    @Override
    public void install(Controller c) throws Exception {
        this.controller = c;
    }

    @Override
    public void uninstall(Controller c) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.controller.storeProperty(this.controller.getClass(), "lookAndFeelClass", UIManager.getSystemLookAndFeelClassName());
            this.frontendListener.updateFrontendUI();
        }
        catch (Exception e1) {
            System.err.println("Could not uninstell LookAndFeelSwitch");
        }
    }

    @Override
    public void storeStates(Controller c) throws Exception {
        super.storeStates(c);
        c.storeProperty(this.getClass(), "activeLookAndFeel", this.activeIndex);
    }

    @Override
    public void restoreStates(Controller c) throws Exception {
        super.restoreStates(c);
        this.activeIndex = c.getProperty(this.getClass(), "activeLookAndFeel", 0);
    }

    @Override
    public int getNumSubPages() {
        return 0;
    }

    @Override
    public String getMainName() {
        return "Look And Feel";
    }

    @Override
    public JPanel getMainPage() {
        return this.getOptionsPanel();
    }

    @Override
    public JPanel getSubPage(int i) {
        return null;
    }

    @Override
    public String getSubPageName(int i) {
        return null;
    }

    @Override
    public PluginInfo getPluginInfo() {
        PluginInfo info = new PluginInfo();
        info.name = "Look And Feel Switch";
        info.vendorName = "Stefan Sechelmann";
        info.icon = ImageHook.getIcon("pictures.png");
        return info;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateLookAndFeel();
        this.updateFrontend();
    }

    @Override
    public Icon getSubPageIcon(int i) {
        return null;
    }

    @Override
    public Icon getMainIcon() {
        return this.getPluginInfo().icon;
    }

    private class OptionsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public OptionsPanel() {
            this.makeLayout();
        }

        private void makeLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            c.anchor = 10;
            c.gridwidth = 0;
            c.weightx = 0.0;
            this.add((Component)LookAndFeelSwitch.this.lnfComboBox, c);
            LookAndFeelSwitch.this.lnfOptionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
            c.weightx = 1.0;
            LookAndFeelSwitch.this.lnfOptionsPanel.setLayout(new GridLayout());
            this.add((Component)LookAndFeelSwitch.this.lnfOptionsPanel, c);
        }
    }

    private class SwitchWorkspaceThread
    extends Thread {
        private LookAndFeelPlugin lnf = null;

        SwitchWorkspaceThread(LookAndFeelPlugin lnf) {
            this.lnf = lnf;
        }

        @Override
        public void run() {
            String lnfClassName = this.lnf.getLnFClassName();
            LookAndFeelSwitch.this.controller.storeProperty(LookAndFeelSwitch.this.controller.getClass(), "lookAndFeelClass", lnfClassName);
            try {
                LookAndFeelSwitch.this.frontendListener.installLookAndFeel(lnfClassName);
                LookAndFeelSwitch.this.frontendListener.updateFrontendUI();
            }
            catch (Exception e1) {
                System.err.println("Could not apply the Look And Feel");
            }
        }
    }
}

