/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.logging;

import de.jtem.jrworkspace.logging.LoggingSystem;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class LoggingSystemTest {
    private Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private static final ByteArrayOutputStream logStream = new ByteArrayOutputStream();
    private static StreamHandler testHandler;
    private static final String message = "Test Message";
    private static File tmpLogFile;
    private static Level defaultLogLevel;

    static {
        tmpLogFile = LoggingSystemTest.tryCreateTmpFile();
        defaultLogLevel = Level.CONFIG;
    }

    @BeforeClass
    public static void initTestHandler() {
        testHandler = new StreamHandler(logStream, new SimpleFormatter()){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        testHandler.setLevel(Level.ALL);
    }

    @BeforeClass
    public static void initFileHandler() {
        if (System.getProperty("de.jtem.jrworkspace.logfile") == null) {
            System.setProperty("de.jtem.jrworkspace.logfile", tmpLogFile.getAbsolutePath());
        } else {
            tmpLogFile = new File(System.getProperty("de.jtem.jrworkspace.logfile"));
        }
    }

    @BeforeClass
    public static void initDefaulLogLevel() {
        if (System.getProperty("de.jtem.jrworkspace.level") == null) {
            System.setProperty("de.jtem.jrworkspace.level", defaultLogLevel.toString());
        } else {
            defaultLogLevel = Level.parse(System.getProperty("de.jtem.jrworkspace.level"));
        }
    }

    @Before
    public void setTestHandler() {
        LoggingSystem.LOGGER.addHandler(testHandler);
        logStream.reset();
    }

    @Test
    public void writeLogMessages() {
        Level[] levelArray = this.levels;
        int n = this.levels.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            LoggingSystem.LOGGER.log(level, message);
            if (level.intValue() >= defaultLogLevel.intValue()) {
                Assert.assertThat((String)("logLevel: " + level), (Object)logStream.toString(), (Matcher)JUnitMatchers.containsString((String)message));
            } else {
                Assert.assertEquals((String)("logLevel: " + level + ", Message size "), (long)0L, (long)logStream.size());
            }
            ++n2;
        }
    }

    @Test
    public void changeLoggersLogLevel() {
        LoggingSystem.LOGGER.log(Level.FINEST, message);
        Assert.assertEquals((String)"Message size ", (long)0L, (long)logStream.size());
        LoggingSystem.LOGGER.setLevel(Level.FINEST);
        LoggingSystem.LOGGER.log(Level.FINEST, message);
        Assert.assertThat((Object)logStream.toString(), (Matcher)JUnitMatchers.containsString((String)message));
        logStream.reset();
        LoggingSystem.LOGGER.log(Level.ALL, message);
        Assert.assertEquals((String)"Message size ", (long)0L, (long)logStream.size());
    }

    @Test
    public void fileHandler() throws IOException {
        String message = "Test Message test file logging";
        LoggingSystem.LOGGER.log(Level.INFO, message);
        boolean found = LoggingSystemTest.doesTmpLogFileContain(message);
        Assert.assertTrue((String)("Log file does not contain \"" + message + "\""), (boolean)found);
    }

    @Test
    public void testWrongLogLevelNameInSystemProperty() {
        System.setProperty("de.jtem.jrworkspace.level", "Severe");
        Assert.assertEquals((Object)Logger.getLogger("").getLevel(), (Object)LoggingSystem.tryToGetLoglevel());
        Assert.assertThat((Object)logStream.toString(), (Matcher)JUnitMatchers.containsString((String)"Could not parse the value of the system property"));
        System.setProperty("de.jtem.jrworkspace.level", "SEVERE");
        Assert.assertEquals((Object)Level.SEVERE, (Object)LoggingSystem.tryToGetLoglevel());
    }

    private static File tryCreateTmpFile() {
        File file = null;
        try {
            file = File.createTempFile("log", ".txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private static boolean doesTmpLogFileContain(String string) throws IOException {
        FileReader reader = new FileReader(tmpLogFile);
        return LoggingSystemTest.doesReaderContain(reader, string);
    }

    private static boolean doesReaderContain(Reader reader, String string) throws IOException {
        String line;
        BufferedReader bReader = new BufferedReader(reader);
        while ((line = bReader.readLine()) != null) {
            if (!line.contains(message)) continue;
            return true;
        }
        return false;
    }
}

