/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteBufferInputStream
extends InputStream {
    private volatile ByteBuffer BBUF;
    protected int mark = 0;
    private static boolean debug = false;

    public ByteBufferInputStream(ByteBuffer bbuf) {
        this.BBUF = bbuf;
        if (debug) {
            this.debug();
        }
    }

    public int read() {
        if (debug) {
            this.debug();
        }
        return this.BBUF.position() < this.BBUF.limit() ? this.BBUF.get() & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        String d = this.BBUF.toString();
        if (debug) {
            this.debug();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.BBUF.position() >= this.BBUF.limit()) {
            this.debug();
            System.out.println("\tnot enough bytes left: " + len + " BBUF at start=" + d);
            return -1;
        }
        if (this.BBUF.position() + len > this.BBUF.limit()) {
            len = this.BBUF.limit() - this.BBUF.position();
        }
        if (len <= 0) {
            return 0;
        }
        this.BBUF.get(b, off, len);
        if (debug) {
            this.debug();
        }
        return len;
    }

    public long skip(long n) {
        if (debug) {
            this.debug();
        }
        if ((long)this.BBUF.position() + n > (long)this.BBUF.limit()) {
            n = this.BBUF.limit() - this.BBUF.position();
        }
        if (n < 0L) {
            return 0L;
        }
        this.BBUF.position(this.BBUF.position() + (int)n);
        if (debug) {
            this.debug();
        }
        return n;
    }

    public int available() {
        if (debug) {
            this.debug();
        }
        return this.BBUF.remaining();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        if (debug) {
            this.debug();
        }
        System.out.println("\treadAheadLimit=" + readAheadLimit);
        this.mark = this.BBUF.position();
    }

    public void reset() {
        this.BBUF.position(this.mark);
    }

    public void close() throws IOException {
    }

    void debug() {
        Logger.getLogger("SMRJ").log(Level.FINER, new Exception().getStackTrace()[1] + " " + this.toString());
    }

    public String toString() {
        return "BBIn: [" + this.BBUF.toString() + "]";
    }
}

