/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp;

import de.smrj.ClientFactory;
import de.smrj.Receiver;
import de.smrj.RemoteCall;
import de.smrj.RemoteThrowable;
import de.smrj.tcp.util.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TCPReceiver
extends Receiver
implements Runnable {
    protected Thread myThread;
    protected boolean running = true;

    public TCPReceiver(String host, int port, int responseType, ClientFactory factory) throws UnknownHostException, IOException {
        super(responseType, factory);
        this.connect(host, port);
    }

    public void run() {
        InputStream is;
        ObjectInputStream ois = null;
        DataInputStream dis = null;
        try {
            is = this.prepareInputStream();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        while (this.isRunning()) {
            boolean ex = false;
            try {
                Object ret;
                try {
                    if (dis == null) {
                        dis = new DataInputStream(is);
                    }
                    try {
                        dis.readInt();
                    }
                    catch (SocketTimeoutException sote) {
                        continue;
                    }
                    catch (EOFException eof) {
                        Logger.getLogger("SMRJ").log(Level.SEVERE, "broadcaster down without notification!");
                        this.stop();
                        continue;
                    }
                    catch (IOException e) {
                        if (!this.isRunning()) continue;
                        throw e;
                    }
                    if (ois == null) {
                        ois = this.createObjectInputStream(is);
                    }
                    RemoteCall rc = (RemoteCall)ois.readObject();
                    ret = this.executeRemoteCall(rc);
                }
                catch (RemoteThrowable rt) {
                    Logger.getLogger("SMRJ").log(Level.INFO, "exception in remote call ", rt);
                    ret = rt;
                    ex = true;
                }
                if (this.getResponseType() == 0) continue;
                this.writeResponse(ret, ex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.closeConnection();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        this.getClientFactory().dispose();
        while (this.myThread.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Logger.getLogger("SMRJ").log(Level.INFO, "TCPReceiver.shutdown() -> done.");
    }

    public synchronized void stop() {
        this.running = false;
    }

    private void writeResponse(Object ret, boolean isException) throws IOException {
        OutputStream os = this.prepareOutputStream();
        if (ret == null) {
            os.write(0);
            return;
        }
        if (isException || this.getResponseType() == 2) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(ret);
            oos.flush();
            bos.prepare();
            byte[] data = bos.toByteArray();
            os.write(1);
            os.write(data);
            Logger.getLogger("SMRJ").log(Level.FINER, "receiver returning " + ret);
            return;
        }
        os.write(0);
    }

    private void connect(String host, int port) throws IOException {
        this.startConnection(host, port);
        Logger.getLogger("SMRJ").log(Level.INFO, "Receiver: connected to {0}:{1}", new Object[]{host, new Integer(port)});
        String name = this.getClass().getName() + " " + host + ':' + port;
        this.myThread = new Thread((Runnable)this, name);
        this.myThread.start();
    }

    protected abstract void startConnection(String var1, int var2) throws IOException;

    protected abstract void closeConnection() throws IOException;

    protected abstract InputStream prepareInputStream() throws IOException;

    protected abstract OutputStream prepareOutputStream() throws IOException;
}

