/*
 * Decompiled with CFR 0.152.
 */
package de.smrj;

import de.smrj.ClientFactory;
import de.smrj.RemoteCall;
import de.smrj.RemoteFactory;
import de.smrj.RemoteKey;
import de.smrj.RemoteThrowable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteObject
implements InvocationHandler {
    static final Method toString;
    static final Method hashCode;
    static final Method equals;
    static final Method clientFactoryGC;
    static final Method clientsDispose;
    private static final Class<?>[] INTERFACE_ARRAY;
    private final RemoteFactory factory;
    private final RemoteKey key;
    private final Object proxy;
    private final Object hash;

    RemoteObject(RemoteFactory factory, Class type, Class[] signature, Object[] args) throws IOException {
        this.factory = factory;
        this.key = RemoteKey.nextKey();
        this.hash = new Integer(this.key.hashCode());
        if (args != null) {
            this.resolveRemoteReferences(args);
        }
        RemoteCall rc = RemoteCall.constructor(this.key, type, signature, args);
        factory.executeRemoteCall(rc);
        this.proxy = Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)this);
        factory.registerProxy(this.key, this.proxy);
        this.deleteQueuedReferences();
    }

    public RemoteObject(RemoteFactory factory, Class type, Class factory3, String name, Class[] signature, Object[] args) throws IOException {
        RemoteCall rc;
        Object ret;
        this.factory = factory;
        this.key = RemoteKey.nextKey();
        this.hash = new Integer(this.key.hashCode());
        if (args != null) {
            this.resolveRemoteReferences(args);
        }
        if ((ret = factory.executeRemoteCall(rc = RemoteCall.factoryMethod(this.key, factory3, name, signature, args))) instanceof RemoteThrowable) {
            throw new RuntimeException((RemoteThrowable)ret);
        }
        LinkedList<Class> interfaces = new LinkedList<Class>();
        for (Class<?> interf : type.getInterfaces()) {
            interfaces.add(interf);
        }
        if (type.isInterface()) {
            interfaces.add(type);
        }
        this.proxy = Proxy.newProxyInstance(type.getClassLoader(), interfaces.toArray(INTERFACE_ARRAY), (InvocationHandler)this);
        factory.registerProxy(this.key, this.proxy);
        this.deleteQueuedReferences();
    }

    private void deleteQueuedReferences() throws IOException {
        Object[] keys = this.factory.pollReleasedKeys();
        if (keys == null) {
            return;
        }
        RemoteCall rc = RemoteCall.method(RemoteKey.CLIENT_FACTORY, clientFactoryGC, new Object[]{keys});
        this.factory.executeRemoteCall(rc);
        Logger.getLogger("SMRJ").finer("num released keys: " + keys.length);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.equals(hashCode)) {
                return this.proxyHashCode();
            }
            if (method.equals(equals)) {
                return this.proxyEquals(args[0]);
            }
            if (method.equals(toString)) {
                return this.proxyToString();
            }
            if (args != null) {
                this.resolveRemoteReferences(args);
            }
            RemoteCall rc = RemoteCall.method(this.key, method, args);
            Object ret = this.factory.executeRemoteCall(rc);
            this.deleteQueuedReferences();
            if (ret == null) {
                return null;
            }
            if (!(ret instanceof RemoteThrowable)) {
                return ret;
            }
            Throwable rt = ((RemoteThrowable)ret).getCause();
            rt.initCause(new Exception("remote call failed"));
            throw rt;
        }
        catch (Throwable e) {
            Logger.getLogger("SMRJ").log(Level.WARNING, "remote call {0}{1}", new Object[]{method, e});
            throw e;
        }
    }

    private final Object proxyHashCode() {
        return this.hash;
    }

    private Object proxyEquals(Object arg) {
        return this == arg;
    }

    private String proxyToString() {
        return "Proxy: key=" + this.key;
    }

    private void resolveRemoteReferences(Object[] params) {
    }

    Object getProxy() {
        return this.proxy;
    }

    public RemoteKey getKey() {
        return this.key;
    }

    static {
        INTERFACE_ARRAY = new Class[0];
        try {
            toString = Object.class.getMethod("toString", new Class[0]);
            hashCode = Object.class.getMethod("hashCode", new Class[0]);
            equals = Object.class.getMethod("equals", Object.class);
            clientFactoryGC = ClientFactory.class.getMethod("gc", Object[].class);
            clientsDispose = ClientFactory.class.getMethod("dispose", new Class[0]);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

