/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class ButtonRemote
extends VRPNDevice
implements Runnable {
    protected Vector changeListeners = new Vector();
    protected static final Object notifyingChangeListenersLock = new Object();

    public ButtonRemote(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    public synchronized void addButtonChangeListener(ButtonChangeListener listener) {
        this.changeListeners.addElement(listener);
    }

    public synchronized boolean removeButtonChangeListener(ButtonChangeListener listener) {
        return this.changeListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stoppedRunning() {
        this.changeListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownButton();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleButtonChange(long tv_sec, long tv_usec, int button, int state) {
        Object object = notifyingChangeListenersLock;
        synchronized (object) {
            ButtonUpdate b = new ButtonUpdate();
            b.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            b.button = button;
            b.state = state;
            Enumeration e = this.changeListeners.elements();
            while (e.hasMoreElements()) {
                ButtonChangeListener l = (ButtonChangeListener)e.nextElement();
                l.buttonUpdate(b, this);
            }
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownButton();

    @Override
    protected native void mainloop();

    public static interface ButtonChangeListener {
        public void buttonUpdate(ButtonUpdate var1, ButtonRemote var2);
    }

    public class ButtonUpdate {
        public Date msg_time = new Date();
        public int button = 0;
        public int state = 0;
    }
}

