/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.BrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.DBrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import de.jtem.numericalMethods.calculus.minimizing.MinimizingOnLine;
import java.io.Serializable;

public final class ConjugateGradient
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double CGOLD = 0.381966;
    static int ITMAX = 100;
    static final double EPS = 1.0E-10;
    private static boolean useDBrent = false;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    public static boolean getUseDBrent() {
        return useDBrent;
    }

    public static void setUseDBrent(boolean v) {
        useDBrent = v;
    }

    public static double search(double[] p, double ftol, RealFunctionOfSeveralVariablesWithGradient f) {
        return ConjugateGradient.search(p, ftol, f, ITMAX, useDBrent, null);
    }

    public static double search(double[] p, double ftol, RealFunctionOfSeveralVariablesWithGradient f, int itMax, boolean useDBrent, Info info) {
        double fp;
        int n = p.length;
        double[] h = new double[n];
        double[] g = new double[n];
        double[] xi = new double[n];
        MinimizingOnLine minimizingOnLine = useDBrent ? new DBrentOnLine(p, xi, f) : new BrentOnLine(p, xi, f);
        double fret = fp = f.eval(p, xi);
        int j = 0;
        while (j < n) {
            g[j] = -xi[j];
            xi[j] = h[j] = g[j];
            ++j;
        }
        if (info != null) {
            info.setMaxIter(itMax);
        }
        int its = 0;
        while (its < itMax) {
            fret = minimizingOnLine.search(2.0E-8);
            if (2.0 * Math.abs(fret - fp) <= ftol * (Math.abs(fret) + Math.abs(fp) + 1.0E-10)) {
                if (info != null) {
                    info.setMessage("ConjugateGradient " + its + ": " + 2.0 * Math.abs(fret - fp) + " (" + ftol * (Math.abs(fret) + Math.abs(fp) + 1.0E-10) + ")");
                    info.setCurrentIter(its);
                    info.printDebug();
                }
                return fret;
            }
            fp = f.eval(p, xi);
            double dgg = 0.0;
            double gg = 0.0;
            int j2 = 0;
            while (j2 < n) {
                gg += g[j2] * g[j2];
                dgg += (xi[j2] + g[j2]) * xi[j2];
                ++j2;
            }
            if (gg == 0.0) {
                if (info != null) {
                    info.setCurrentIter(its);
                    info.printDebug();
                }
                return fret;
            }
            double gam = dgg / gg;
            int j3 = 0;
            while (j3 < n) {
                g[j3] = -xi[j3];
                xi[j3] = h[j3] = g[j3] + gam * h[j3];
                ++j3;
            }
            ++its;
        }
        if (info != null) {
            info.setCurrentIter(itMax);
            info.setMessage(String.valueOf(info.getMessage()) + "\n" + "Too many iterations in ConjugateGradient\n");
        }
        return fret;
    }
}

