/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.differentiation;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import java.io.Serializable;

public final class NumericalGradient
implements RealFunctionOfSeveralVariablesWithGradient,
Serializable {
    private static final long serialVersionUID = 1L;
    RealFunctionOfSeveralVariables f;
    int n;
    double h;

    public NumericalGradient(RealFunctionOfSeveralVariables theF) {
        this(theF, 1.0E-8);
    }

    public NumericalGradient(RealFunctionOfSeveralVariables theF, double theH) {
        this.f = theF;
        this.n = theF.getNumberOfVariables();
        this.h = theH;
    }

    public double getH() {
        return this.h;
    }

    public void setH(double v) {
        this.h = v;
    }

    @Override
    public int getNumberOfVariables() {
        return this.n;
    }

    @Override
    public double eval(double[] x) {
        return this.f.eval(x);
    }

    @Override
    public double eval(double[] x, double[] grad) {
        return NumericalGradient.computeGradient(this.f, x, grad, this.h);
    }

    public static double computeGradient(RealFunctionOfSeveralVariables f, double[] x, double[] grad, double h) {
        int n = f.getNumberOfVariables();
        double fp = f.eval(x);
        int i = 0;
        while (i < n) {
            double tmp = x[i];
            int n2 = i;
            x[n2] = x[n2] + h;
            double h_ = x[i] - tmp;
            grad[i] = (f.eval(x) - fp) / h_;
            x[i] = tmp;
            ++i;
        }
        return fp;
    }
}

