/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.CommonAbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.jaxen.MatchesFunction;
import net.sourceforge.pmd.rules.DynamicXPathRule;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPath;

public class XPathRule
extends CommonAbstractRule {
    private XPath xpath;
    private boolean regexpFunctionRegistered;

    public static Class loadClass(ClassLoader classloader, String xpath, String name) {
        if (xpath.indexOf(124) != -1) {
            return XPathRule.class;
        }
        String part = xpath.trim();
        if (!part.matches("(?s)//\\w+\\W.*")) {
            return XPathRule.class;
        }
        String tail = part.replaceFirst("^//\\w+", "");
        String nodeName = part.substring(2, part.indexOf(tail));
        return DynamicXPathRule.loadClass(classloader, nodeName);
    }

    public void evaluate(Node compilationUnit, RuleContext data) {
        try {
            this.initializeXPathExpression();
            List results = this.xpath.selectNodes(compilationUnit);
            Iterator i = results.iterator();
            while (i.hasNext()) {
                SimpleNode n = (SimpleNode)i.next();
                if (n instanceof ASTVariableDeclaratorId && this.getBooleanProperty("pluginname")) {
                    this.addViolation((Object)data, n, n.getImage());
                    continue;
                }
                this.addViolation((Object)data, n, this.getMessage());
            }
        }
        catch (JaxenException ex) {
            XPathRule.throwJaxenAsRuntime(ex);
        }
    }

    private void initializeXPathExpression() throws JaxenException {
        if (this.xpath != null) {
            return;
        }
        if (!this.regexpFunctionRegistered) {
            MatchesFunction.registerSelfInSimpleContext();
            this.regexpFunctionRegistered = true;
        }
        this.xpath = new BaseXPath(this.getStringProperty("xpath"), new DocumentNavigator());
        if (this.properties.size() > 1) {
            SimpleVariableContext vc = new SimpleVariableContext();
            Iterator<Map.Entry<Object, Object>> i = this.properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> e = i.next();
                if ("xpath".equals(e.getKey())) continue;
                vc.setVariableValue((String)e.getKey(), e.getValue());
            }
            this.xpath.setVariableContext(vc);
        }
    }

    private static void throwJaxenAsRuntime(final JaxenException ex) {
        throw new RuntimeException(){

            public void printStackTrace() {
                super.printStackTrace();
                ex.printStackTrace();
            }

            public void printStackTrace(PrintWriter writer) {
                super.printStackTrace(writer);
                ex.printStackTrace(writer);
            }

            public void printStackTrace(PrintStream stream) {
                super.printStackTrace(stream);
                ex.printStackTrace(stream);
            }

            public String getMessage() {
                return super.getMessage() + ex.getMessage();
            }
        };
    }

    public void apply(List astCompilationUnits, RuleContext ctx) {
        Iterator i = astCompilationUnits.iterator();
        while (i.hasNext()) {
            this.evaluate((Node)i.next(), ctx);
        }
    }
}

