/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class UnusedPrivateMethodRule
extends AbstractRule {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTInitializer;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map methods = ((ClassScope)node.getScope()).getMethodDeclarations();
        Iterator i = this.findUnique(methods).iterator();
        while (i.hasNext()) {
            MethodNameDeclaration mnd = (MethodNameDeclaration)i.next();
            List occs = (List)methods.get(mnd);
            if (!this.privateAndNotExcluded(mnd)) continue;
            if (occs.isEmpty()) {
                this.addViolation(data, mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
                continue;
            }
            if (!this.calledFromOutsideItself(occs, mnd)) continue;
            this.addViolation(data, mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
        }
        return data;
    }

    private Set findUnique(Map methods) {
        HashSet<MethodNameDeclaration> unique = new HashSet<MethodNameDeclaration>();
        HashSet<String> sigs = new HashSet<String>();
        Iterator i = methods.keySet().iterator();
        while (i.hasNext()) {
            MethodNameDeclaration mnd = (MethodNameDeclaration)i.next();
            String sig = mnd.getImage() + mnd.getParameterCount();
            if (!sigs.contains(sig)) {
                unique.add(mnd);
            }
            sigs.add(sig);
        }
        return unique;
    }

    private boolean calledFromOutsideItself(List occs, MethodNameDeclaration mnd) {
        int callsFromOutsideMethod = 0;
        Iterator i = occs.iterator();
        while (i.hasNext()) {
            NameOccurrence occ = (NameOccurrence)i.next();
            SimpleNode occNode = occ.getLocation();
            ASTConstructorDeclaration enclosingConstructor = (ASTConstructorDeclaration)occNode.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? UnusedPrivateMethodRule.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration") : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration);
            if (enclosingConstructor != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTInitializer enclosingInitializer = (ASTInitializer)occNode.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTInitializer == null ? UnusedPrivateMethodRule.class$("net.sourceforge.pmd.ast.ASTInitializer") : class$net$sourceforge$pmd$ast$ASTInitializer);
            if (enclosingInitializer != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTMethodDeclaration enclosingMethod = (ASTMethodDeclaration)occNode.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? UnusedPrivateMethodRule.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration") : class$net$sourceforge$pmd$ast$ASTMethodDeclaration);
            if (enclosingMethod != null && (enclosingMethod == null || mnd.getNode().jjtGetParent().equals(enclosingMethod))) continue;
            ++callsFromOutsideMethod;
        }
        return callsFromOutsideMethod == 0;
    }

    private boolean privateAndNotExcluded(MethodNameDeclaration mnd) {
        ASTMethodDeclarator node = (ASTMethodDeclarator)mnd.getNode();
        return ((AccessNode)node.jjtGetParent()).isPrivate() && !node.hasImageEqualTo("readObject") && !node.hasImageEqualTo("writeObject") && !node.hasImageEqualTo("readResolve") && !node.hasImageEqualTo("writeReplace");
    }
}

