/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PMD;

public class SourceCode {
    private CodeLoader cl;

    public SourceCode(CodeLoader cl) {
        this.cl = cl;
    }

    public List getCode() {
        return this.cl.getCode();
    }

    public StringBuffer getCodeBuffer() {
        StringBuffer sb = new StringBuffer();
        List lines = this.cl.getCode();
        for (int i = 0; i < lines.size(); ++i) {
            sb.append((String)lines.get(i));
            sb.append(PMD.EOL);
        }
        return sb;
    }

    public String getSlice(int startLine, int endLine) {
        StringBuffer sb = new StringBuffer();
        List lines = this.cl.getCode();
        for (int i = startLine - 1; i < endLine && i < lines.size(); ++i) {
            if (sb.length() != 0) {
                sb.append(PMD.EOL);
            }
            sb.append((String)lines.get(i));
        }
        return sb.toString();
    }

    public String getFileName() {
        return this.cl.getFileName();
    }

    public static class StringCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_STRING";
        private String source_code;
        private String name;

        public StringCodeLoader(String code) {
            this(code, DEFAULT_NAME);
        }

        public StringCodeLoader(String code, String name) {
            this.source_code = code;
            this.name = name;
        }

        public Reader getReader() {
            return new StringReader(this.source_code);
        }

        public String getFileName() {
            return this.name;
        }
    }

    public static class FileCodeLoader
    extends CodeLoader {
        private File file;

        public FileCodeLoader(File file) {
            this.file = file;
        }

        public Reader getReader() throws Exception {
            return new FileReader(this.file);
        }

        public String getFileName() {
            return this.file.getAbsolutePath();
        }
    }

    public static abstract class CodeLoader {
        private SoftReference code;

        public List getCode() {
            List c = null;
            if (this.code != null) {
                c = (List)this.code.get();
            }
            if (c != null) {
                return c;
            }
            this.code = new SoftReference<List>(this.load());
            return (List)this.code.get();
        }

        public abstract String getFileName();

        protected abstract Reader getReader() throws Exception;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected List load() {
            ArrayList<String> arrayList;
            LineNumberReader lnr = null;
            try {
                try {
                    String currentLine;
                    lnr = new LineNumberReader(this.getReader());
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((currentLine = lnr.readLine()) != null) {
                        lines.add(currentLine);
                    }
                    arrayList = lines;
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (lnr == null) throw throwable;
                    lnr.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e2.getMessage());
                }
            }
            try {}
            catch (Exception e2) {
                throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e2.getMessage());
            }
            if (lnr == null) return arrayList;
            lnr.close();
            return arrayList;
        }
    }
}

