/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.metrics.signature;

import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;

public abstract class ApexSignature {
    public final Visibility visibility;

    protected ApexSignature(Visibility visibility) {
        this.visibility = visibility;
    }

    public static enum Visibility {
        PRIVATE,
        PUBLIC,
        PROTECTED,
        GLOBAL;


        public static Visibility get(ASTMethod method) {
            ASTModifierNode modifierNode = (ASTModifierNode)method.getFirstChildOfType(ASTModifierNode.class);
            if (modifierNode.isPublic()) {
                return PUBLIC;
            }
            if (modifierNode.isPrivate()) {
                return PRIVATE;
            }
            if (modifierNode.isProtected()) {
                return PROTECTED;
            }
            return GLOBAL;
        }
    }
}

