/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.Initializer;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.ReifiedMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.base.Equivalence;
import java.util.Map;
import java.util.Optional;

class ReifiedMethodsInitializer
implements Initializer<MethodTable, TypeInfo> {
    ReifiedMethodsInitializer() {
    }

    @Override
    public MethodTable get(TypeInfo inputType) {
        GenericTypeInfo type = GenericTypeInfoUtil.asGenericType(inputType);
        assert (type.getUnreifiedType() != null) : "using an unreified type for a reified table makes no sense";
        return this.createClonedMethods(type, type.getRootUnreifiedType());
    }

    private MethodTable createClonedMethods(GenericTypeInfo targetType, TypeInfo rootUnreifiedType) {
        Map<Equivalence.Wrapper<TypeInfo>, TypeInfo> unparameterizedToParameterized = ArgumentTypeInfoConverter.getResolutionMap(targetType, rootUnreifiedType);
        StandardMethodTable clonedMethods = new StandardMethodTable();
        for (MethodInfo method : rootUnreifiedType.methods().all()) {
            ReifiedMethodInfo cloneMethod = new ReifiedMethodInfo(method, ArgumentTypeInfoConverter.convertTypeWithPeelingIfNecessary(unparameterizedToParameterized, method.getReturnType(), Optional.of(targetType)), ArgumentTypeInfoConverter.convertParameters(unparameterizedToParameterized, method.getParameters()), targetType);
            clonedMethods.addNoDuplicatesAllowed(cloneMethod).throwIfError();
        }
        return clonedMethods.resolve();
    }
}

