/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class TypeContext
extends AnnotationContext {
    private final TypeInfo type;

    public TypeContext(TypeInfo type, AstNode node, SymbolScope scope) {
        super(node, scope);
        this.type = type;
    }

    public TypeContext(Compilation node, SymbolScope scope) {
        super(node, scope);
        this.type = node.getDefiningType();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.type;
    }

    @Override
    public Element getElement() {
        switch (this.type.getUnitType()) {
            case CLASS: {
                return Element.CLASS;
            }
            case INTERFACE: {
                return Element.INTERFACE;
            }
            case ENUM: {
                return Element.ENUM;
            }
            case ANONYMOUS: {
                return Element.CLASS;
            }
        }
        throw new UnexpectedCodePathException();
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.type.getModifiers();
    }

    @Override
    public void accept(AnnotationContextRule visitor) {
        visitor.validate(this);
    }
}

