/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.exception.UnexpectedCodePathException;

class BooleanOps {
    private static final BooleanOps INSTANCE = new BooleanOps();
    private final Comparison.UnaryComparison EQUAL = new Comparison.UnaryComparison(159);
    private final Comparison.UnaryComparison NOT_EQUAL = new Comparison.UnaryComparison(160);
    private final Comparison.UnaryComparison LESS_THAN = new Comparison.UnaryComparison(161);
    private final Comparison.UnaryComparison GREATER_THAN = new Comparison.UnaryComparison(163);
    private final Comparison.UnaryComparison LESS_THAN_EQUAL = new Comparison.UnaryComparison(164);
    private final Comparison.UnaryComparison GREATER_THAN_EQUAL = new Comparison.UnaryComparison(162);

    private BooleanOps() {
    }

    public static BooleanOps get() {
        return INSTANCE;
    }

    Comparison getIntegerComparison(BooleanOp op) {
        switch (op) {
            case DOUBLE_EQUAL: {
                return this.EQUAL;
            }
            case NOT_EQUAL: 
            case ALT_NOT_EQUAL: {
                return this.NOT_EQUAL;
            }
            case LESS_THAN: {
                return this.LESS_THAN;
            }
            case GREATER_THAN: {
                return this.GREATER_THAN;
            }
            case LESS_THAN_EQUAL: {
                return this.LESS_THAN_EQUAL;
            }
            case GREATER_THAN_EQUAL: {
                return this.GREATER_THAN_EQUAL;
            }
        }
        throw new UnexpectedCodePathException();
    }

    Integer getUnaryOpcode(BooleanOp op) {
        switch (op) {
            case DOUBLE_EQUAL: 
            case TRIPLE_EQUAL: {
                return 153;
            }
            case NOT_EQUAL: 
            case ALT_NOT_EQUAL: 
            case NOT_TRIPLE_EQUAL: {
                return 154;
            }
            case LESS_THAN: {
                return 155;
            }
            case GREATER_THAN: {
                return 157;
            }
            case LESS_THAN_EQUAL: {
                return 158;
            }
            case GREATER_THAN_EQUAL: {
                return 156;
            }
        }
        throw new UnexpectedCodePathException();
    }
}

