/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.ast.expression.Comparisons;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.ResetLazyLabelsVisitor;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.List;
import org.objectweb.asm.Label;

public class BooleanExpression
extends Expression {
    private static final AstVisitor<BooleanScope> IS_NULLABLE = new AstVisitor<BooleanScope>(){

        @Override
        protected boolean defaultVisit() {
            return false;
        }

        @Override
        public void visitEnd(LiteralExpression node, BooleanScope scope) {
            scope.setValue(node.getLiteralType() == LiteralType.NULL);
        }
    };
    private final Location loc;
    private final Expression left;
    private final Expression right;
    private final BooleanOp op;
    private Label exit;
    private Label trueLabel;
    private Label falseLabel;
    private TypeInfo commonType;

    public BooleanExpression(AstNode definingNode, Expr.BooleanExpr expr) {
        super(definingNode);
        this.op = expr.op;
        this.loc = Locations.from(expr);
        this.left = AstNodes.get().create((AstNode)this, expr.left);
        this.right = AstNodes.get().create((AstNode)this, expr.right);
        this.exit = new Label();
        this.trueLabel = new Label();
        this.falseLabel = new Label();
    }

    private static boolean isNullable(Expression expression) {
        return BooleanScope.evaluate(expression, IS_NULLABLE, true);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.left.validate(symbols, scope);
        this.right.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.left, this.right)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.commonType = Distance.get().getCommonType(this.getDefiningType(), this.left.getType(), this.right.getType());
        if (this.commonType == null && this.op.isComparison() || this.isAnyTypeNull() && !this.op.isEquality()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.comparison.types", this.left.getType(), this.right.getType()));
            return;
        }
        this.operatorValidate(scope);
        this.setType(TypeInfos.BOOLEAN);
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.op.isComparison()) {
            this.emitComparison(emitter);
            emitter.push(this.loc, true);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emitJump(this.loc, 167, this.exit);
            emitter.emit(this.falseLabel);
            emitter.push(this.loc, false);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(this.exit);
        } else if (this.op == BooleanOp.AND) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : this.foldExpressions(BooleanOp.AND)) {
                if (BooleanOp.isComparison(ExpressionUtil.getBooleanOp(expression))) {
                    BooleanExpression booleanExpression = ExpressionUtil.getBooleanExpression(expression);
                    booleanExpression.emitComparison(emitter);
                    builder.add(booleanExpression.falseLabel);
                    booleanExpression.resetLabels();
                    continue;
                }
                expression.emit(emitter);
                emitter.unbox(TypeInfos.BOOLEAN);
                emitter.emitJump(this.loc, 153, this.falseLabel);
            }
            emitter.push(this.loc, true);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emitJump(this.loc, 167, this.exit);
            for (Label label : builder.build()) {
                emitter.emit(label);
            }
            emitter.emit(this.falseLabel);
            emitter.push(this.loc, false);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(this.exit);
        } else if (this.op == BooleanOp.OR) {
            for (Expression expression : this.foldExpressions(BooleanOp.OR)) {
                if (BooleanOp.isComparison(ExpressionUtil.getBooleanOp(expression))) {
                    BooleanExpression booleanExpression = ExpressionUtil.getBooleanExpression(expression);
                    booleanExpression.emitComparison(emitter);
                    emitter.emitJump(this.loc, 167, this.trueLabel);
                    emitter.emit(booleanExpression.falseLabel);
                    booleanExpression.resetLabels();
                    continue;
                }
                expression.emit(emitter);
                emitter.unbox(TypeInfos.BOOLEAN);
                emitter.emitJump(this.loc, 154, this.trueLabel);
            }
            emitter.push(this.loc, false);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emitJump(this.loc, 167, this.exit);
            emitter.emit(this.trueLabel);
            emitter.push(this.loc, true);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(this.exit);
        } else {
            throw new UnexpectedCodePathException();
        }
        this.resetLabels();
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    private void operatorValidate(ValidationScope scope) {
        switch (this.op) {
            case DOUBLE_EQUAL: 
            case NOT_EQUAL: 
            case ALT_NOT_EQUAL: {
                break;
            }
            case TRIPLE_EQUAL: 
            case NOT_TRIPLE_EQUAL: {
                if (this.commonType.getBasicType().isReference()) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.exact.equality.type", this.commonType));
                break;
            }
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: {
                if (this.commonType.getBasicType().allowsInequality()) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.inequality.type", this.commonType));
                break;
            }
            case AND: 
            case OR: {
                if (this.commonType != null && TypeInfoEquivalence.isEquivalent(TypeInfos.BOOLEAN, this.commonType)) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.logical.type", TypeInfos.BOOLEAN));
            }
        }
    }

    private boolean isAnyTypeNull() {
        return this.left.getType().getBasicType() == BasicType.NULL || this.right.getType().getBasicType() == BasicType.NULL;
    }

    private List<Expression> foldExpressions(BooleanOp op) {
        BooleanExpression current;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (op != ExpressionUtil.getBooleanOp(this.left)) {
            builder.add(this.left);
            builder.add(this.right);
            return builder.build();
        }
        ArrayDeque<Expression> expressions = Queues.newArrayDeque();
        expressions.push(this.left);
        while (op == ExpressionUtil.getBooleanOp((Expression)expressions.peek())) {
            current = ExpressionUtil.getBooleanExpression((Expression)expressions.peek());
            expressions.push(current.left);
        }
        builder.add(expressions.pop());
        while (!expressions.isEmpty()) {
            current = ExpressionUtil.getBooleanExpression((Expression)expressions.pop());
            builder.add(current.right);
        }
        builder.add(this.right);
        return builder.build();
    }

    public void emitComparison(Emitter emitter) {
        Comparison comparison = Comparisons.get(this.commonType, this.op);
        if (TypeInfoEquivalence.isEquivalent(InternalTypeInfos.NULL, this.left.getType())) {
            this.emitNull(emitter, this.right);
        } else if (TypeInfoEquivalence.isEquivalent(InternalTypeInfos.NULL, this.right.getType())) {
            this.emitNull(emitter, this.left);
        } else if (BooleanExpression.isNullable(this.left)) {
            this.left.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.left.getType(), this.commonType);
            emitter.emit(this.loc, 89);
            Label leftNotNull = new Label();
            emitter.emitJump(this.loc, 199, leftNotNull);
            emitter.emit(this.loc, 87);
            boolean rightNullable = BooleanExpression.isNullable(this.right);
            if (rightNullable) {
                this.emitLeftNullRightNullable(emitter);
            } else {
                this.emitLeftNullRightNonNull(emitter);
            }
            emitter.emit(leftNotNull);
            this.resetLazyLabels(this.right);
            if (rightNullable) {
                this.emitLeftNonNullRightNullable(emitter, comparison);
            } else {
                comparison.emitUnbox(emitter, this.commonType);
                this.right.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
                comparison.emitUnbox(emitter, this.commonType);
                comparison.emitComparison(this.loc, emitter, this.falseLabel);
            }
        } else {
            boolean rightNullable = BooleanExpression.isNullable(this.right);
            if (rightNullable) {
                this.left.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.left.getType(), this.commonType);
                this.emitLeftNonNullRightNullable(emitter, comparison);
            } else {
                this.left.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.left.getType(), this.commonType);
                comparison.emitUnbox(emitter, this.commonType);
                this.right.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
                comparison.emitUnbox(emitter, this.commonType);
                comparison.emitComparison(this.loc, emitter, this.falseLabel);
            }
        }
        emitter.emit(this.trueLabel);
    }

    private void resetLazyLabels(Expression expression) {
        expression.traverse(ResetLazyLabelsVisitor.get(), NoopScope.get());
    }

    private void emitNull(Emitter emitter, Expression expression) {
        switch (this.op) {
            case DOUBLE_EQUAL: 
            case TRIPLE_EQUAL: {
                expression.emit(emitter);
                TypeConversion.emit(this.loc, emitter, expression.getType(), this.commonType);
                emitter.emitJump(this.loc, 199, this.falseLabel);
                return;
            }
            case NOT_EQUAL: 
            case ALT_NOT_EQUAL: 
            case NOT_TRIPLE_EQUAL: {
                expression.emit(emitter);
                TypeConversion.emit(this.loc, emitter, expression.getType(), this.commonType);
                emitter.emitJump(this.loc, 198, this.falseLabel);
                return;
            }
        }
        throw new UnexpectedCodePathException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void emitLeftNullRightNullable(Emitter emitter) {
        if (this.op.isEqual()) {
            this.right.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
            emitter.emitJump(this.loc, 199, this.falseLabel);
            emitter.emitJump(this.loc, 167, this.trueLabel);
            return;
        } else if (this.op.isNotEqual()) {
            this.right.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
            emitter.emitJump(this.loc, 198, this.falseLabel);
            emitter.emitJump(this.loc, 167, this.trueLabel);
            return;
        } else if (this.commonType.equals(TypeInfos.STRING) || this.commonType.equals(TypeInfos.ID)) {
            if (this.op == BooleanOp.LESS_THAN) {
                this.right.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
                emitter.emitJump(this.loc, 198, this.falseLabel);
                emitter.emitJump(this.loc, 167, this.trueLabel);
                return;
            } else if (this.op == BooleanOp.LESS_THAN_EQUAL) {
                this.right.emit(emitter);
                emitter.emit(this.loc, 87);
                emitter.emitJump(this.loc, 167, this.trueLabel);
                return;
            } else if (this.op == BooleanOp.GREATER_THAN) {
                this.right.emit(emitter);
                emitter.emit(this.loc, 87);
                emitter.emitJump(this.loc, 167, this.falseLabel);
                return;
            } else {
                if (this.op != BooleanOp.GREATER_THAN_EQUAL) throw new UnexpectedCodePathException();
                this.right.emit(emitter);
                TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
                emitter.emitJump(this.loc, 198, this.trueLabel);
                emitter.emitJump(this.loc, 167, this.falseLabel);
            }
            return;
        } else {
            this.right.emit(emitter);
            emitter.emit(this.loc, 87);
            emitter.emitJump(this.loc, 167, this.falseLabel);
        }
    }

    private void emitLeftNullRightNonNull(Emitter emitter) {
        if (this.op.isNotEqual()) {
            emitter.emitJump(this.loc, 167, this.trueLabel);
        } else if ((this.op == BooleanOp.LESS_THAN || this.op == BooleanOp.LESS_THAN_EQUAL) && this.isStringOrId(this.commonType)) {
            emitter.emitJump(this.loc, 167, this.trueLabel);
        } else {
            emitter.emitJump(this.loc, 167, this.falseLabel);
        }
    }

    private void emitLeftNonNullRightNullable(Emitter emitter, Comparison comparison) {
        if (this.isDoubleOrLong(this.left.getType()) || this.isDoubleOrLong(this.commonType)) {
            this.emitWide(emitter, comparison);
        } else {
            this.emitNarrow(emitter, comparison);
        }
        TypeConversion.emit(this.loc, emitter, this.right.getType(), this.commonType);
        comparison.emitUnbox(emitter, this.commonType);
        comparison.emitComparison(this.loc, emitter, this.falseLabel);
    }

    private boolean isDoubleOrLong(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(type, TypeInfos.DOUBLE) || TypeInfoEquivalence.isEquivalent(type, TypeInfos.LONG);
    }

    private boolean isStringOrId(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(type, TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(type, TypeInfos.ID);
    }

    private void emitNarrow(Emitter emitter, Comparison comparison) {
        comparison.emitUnbox(emitter, this.commonType);
        this.right.emit(emitter);
        emitter.emit(this.loc, 89);
        this.emitRightNullCheck(emitter, 88);
    }

    private void emitWide(Emitter emitter, Comparison comparison) {
        this.right.emit(emitter);
        emitter.emit(this.loc, 89);
        int rightVariablePos = emitter.getMethodStack().peek().getLocalVariables().add();
        emitter.emitVar(this.loc, 58, rightVariablePos);
        this.emitRightNullCheck(emitter, 87);
        comparison.emitUnbox(emitter, this.commonType);
        emitter.emitVar(this.loc, 25, rightVariablePos);
        emitter.emit(this.loc, 1);
        emitter.emitVar(this.loc, 58, rightVariablePos);
        emitter.getMethodStack().peek().getLocalVariables().clear(rightVariablePos);
    }

    private void emitRightNullCheck(Emitter emitter, int opcode) {
        assert (opcode == 87 || opcode == 88);
        Label rightNotNull = new Label();
        emitter.emitJump(this.loc, 199, rightNotNull);
        if (this.op.isNotEqual()) {
            emitter.emit(this.loc, opcode);
            emitter.emitJump(this.loc, 167, this.trueLabel);
        } else if ((this.op == BooleanOp.GREATER_THAN || this.op == BooleanOp.GREATER_THAN_EQUAL) && this.isStringOrId(this.commonType)) {
            emitter.emit(this.loc, opcode);
            emitter.emitJump(this.loc, 167, this.trueLabel);
        } else {
            emitter.emit(this.loc, opcode);
            emitter.emitJump(this.loc, 167, this.falseLabel);
        }
        emitter.emit(rightNotNull);
    }

    public Label getFalseLabel() {
        return this.falseLabel;
    }

    public void resetLabels() {
        this.exit = new Label();
        this.trueLabel = new Label();
        this.falseLabel = new Label();
    }

    public BooleanOp getOp() {
        return this.op;
    }

    public Expression getRight() {
        return this.right;
    }
}

