/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.references;

import apex.jorje.data.Location;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.references.ReferenceStrategy;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.ReferenceLocationsUtil;
import apex.jorje.lsp.impl.visitors.ReferenceSourceVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedUsageReferenceStrategy
implements ReferenceStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TrackedUsageReferenceStrategy.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ReferenceLocationProvider referenceLocationProvider;

    @Inject
    public TrackedUsageReferenceStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, Provider<ApexIndex> apexIndexProvider, ReferenceLocationProvider referenceLocationProvider) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.apexIndexProvider = apexIndexProvider;
        this.referenceLocationProvider = referenceLocationProvider;
    }

    @Override
    public List<? extends org.eclipse.lsp4j.Location> provideReferences(TextDocumentPositionParams params) {
        URI docUri = URI.create(params.getTextDocument().getUri());
        Optional<Document> optDoc = this.documentService.retrieve(docUri);
        ArrayList items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            try {
                ReferenceSourceVisitor referenceSourceVisitor = new ReferenceSourceVisitor(Locations.getOffset(doc, params.getPosition()));
                CodeUnit codeUnit = this.compilerService.compile((Document)doc, referenceSourceVisitor);
                Optional<Either<TypeInfo, Member>> refSymbol = referenceSourceVisitor.getSymbol();
                refSymbol.ifPresent(symbol -> {
                    if (symbol.getLeft() != null) {
                        items.addAll(this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), (TypeInfo)symbol.getLeft()));
                    } else if (symbol.getRight() != null) {
                        Member memberSymbol = (Member)symbol.getRight();
                        switch (memberSymbol.getMemberType()) {
                            case LOCAL: {
                                List<Location> matchingLocations = ReferenceLocationsUtil.getVariableReferenceLocations(codeUnit, (Variable)memberSymbol);
                                List localVarLocations = matchingLocations.stream().map(ref -> Locations.from(docUri, ref)).collect(Collectors.toList());
                                items.addAll(localVarLocations);
                                break;
                            }
                            case METHOD: {
                                MethodInfo method = (MethodInfo)memberSymbol;
                                if (method.getModifiers().has(ModifierTypeInfos.STATIC) || method.isConstructor()) {
                                    items.addAll(this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), method));
                                    break;
                                }
                                items.addAll(this.referenceLocationProvider.getInstanceMethodLocations(this.apexIndexProvider, this.compilerService, method));
                                break;
                            }
                            case FIELD: 
                            case PROPERTY: 
                            case DYNAMIC: {
                                items.addAll(this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), memberSymbol));
                                break;
                            }
                            default: {
                                logger.error("Unknown member type encountered when processing find all references: " + memberSymbol.getMemberType().name());
                                throw new UnexpectedCodePathException("unknown member type: " + memberSymbol.getMemberType().name());
                            }
                        }
                    }
                });
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing definition", (Throwable)ble);
            }
        });
        return items;
    }
}

