/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.telemetry.TelemetryHandler;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.StringCompletionActivationStrategy;
import apex.jorje.lsp.impl.debug.DebugOptions;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexCompletionStrategyAggregator
implements CompletionStrategy {
    private final Logger logger;
    private final Set<CompletionStrategy> strategies;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;
    private final TelemetryHandler telemetryHandler;

    @Inject
    public ApexCompletionStrategyAggregator(Set<CompletionStrategy> completionStrategies, ApexDocumentService documentService, CompletionActivationFactory factory, TelemetryHandler telemetryHandler) {
        this.strategies = completionStrategies;
        this.documentService = documentService;
        this.factory = factory;
        this.telemetryHandler = telemetryHandler;
        this.logger = LoggerFactory.getLogger(ApexCompletionStrategyAggregator.class);
    }

    public ApexCompletionStrategyAggregator(Set<CompletionStrategy> completionStrategies, ApexDocumentService documentService, CompletionActivationFactory factory, Logger logger, TelemetryHandler telemetryHandler) {
        this.strategies = completionStrategies;
        this.documentService = documentService;
        this.factory = factory;
        this.logger = logger;
        this.telemetryHandler = telemetryHandler;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        TelemetryData telemetryData = new TelemetryData("Apex-Completions");
        ArrayList<CompletionItem> items = Lists.newArrayList();
        ArrayList<StrategyStatistics> statistics = new ArrayList<StrategyStatistics>();
        if (this.isOutsideStringLiteralContext(params)) {
            for (CompletionStrategy strategy : this.strategies) {
                try {
                    Stopwatch strategyTime = Stopwatch.createStarted();
                    List<CompletionItem> strategyItems = strategy.provideCompletions(params);
                    statistics.add(new StrategyStatistics(strategy.getClass().getSimpleName(), strategyTime.elapsed(TimeUnit.MILLISECONDS), strategyItems.size()));
                    items.addAll(strategyItems);
                }
                catch (Exception e) {
                    this.logger.error(String.format("Encountered an error with strategy %s", strategy), (Throwable)e);
                }
            }
        }
        stopwatch.stop();
        if (DebugOptions.shouldPrintCompletionStatistics()) {
            long executionTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            telemetryData.addExecutionTime(executionTime);
            this.logger.info("Completions for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)executionTime);
            for (StrategyStatistics stat : statistics) {
                telemetryData.add(String.format("%s-time", stat.name), stat.time);
                telemetryData.add(String.format("%s-size", stat.name), stat.size);
                stat.printStats(this.logger);
            }
            this.telemetryHandler.send(telemetryData);
        }
        return items;
    }

    private boolean isOutsideStringLiteralContext(TextDocumentPositionParams params) {
        String uri = params.getTextDocument().getUri();
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(uri));
        MutableBoolean outsideStringLiteral = new MutableBoolean(true);
        optDoc.ifPresent(doc -> {
            StringCompletionActivationStrategy strategy = this.factory.createStringBasedStrategy((Document)doc, params.getPosition());
            try {
                strategy.analyze();
                if (strategy.isStringLiteral()) {
                    outsideStringLiteral.setValue(false);
                }
            }
            catch (BadLocationException e) {
                this.logger.error("Encountered a bad location while providing completion", (Throwable)e);
            }
        });
        return outsideStringLiteral.getValue();
    }

    private static class StrategyStatistics {
        private final String name;
        private final Long time;
        private final int size;

        public StrategyStatistics(String name, Long time, int size) {
            this.name = name;
            this.time = time;
            this.size = size;
        }

        public void printStats(Logger logger) {
            logger.info("Strategy: " + this.name + "; Time Taken [ms]: " + this.time + "; Number of Items Added: " + this.size);
        }
    }
}

