/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.document;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.document.Document;
import net.sourceforge.pmd.document.RegionByLine;
import net.sourceforge.pmd.document.RegionByOffset;
import net.sourceforge.pmd.document.RegionByOffsetImp;
import net.sourceforge.pmd.util.IOUtil;

public class DocumentFile
implements Document,
Closeable {
    private static final Logger LOG = Logger.getLogger(DocumentFile.class.getName());
    private List<Integer> lineToOffset = new ArrayList<Integer>();
    private final Path filePath;
    private final BufferedReader reader;
    private int currentPosition = 0;
    private final Path temporaryPath = Files.createTempFile("pmd-", ".tmp", new FileAttribute[0]);
    private final Writer writer;

    public DocumentFile(File file, Charset charset) throws IOException {
        this.reader = Files.newBufferedReader(Objects.requireNonNull(file).toPath(), Objects.requireNonNull(charset));
        this.writer = Files.newBufferedWriter(this.temporaryPath, charset, new OpenOption[0]);
        this.filePath = file.toPath();
        this.mapLinesToOffsets();
    }

    private void mapLinesToOffsets() throws IOException {
        try (Scanner scanner = new Scanner(this.filePath);){
            int currentGlobalOffset = 0;
            while (scanner.hasNextLine()) {
                this.lineToOffset.add(currentGlobalOffset);
                currentGlobalOffset += this.getLineLengthWithLineSeparator(scanner);
            }
        }
    }

    private int getLineLengthWithLineSeparator(Scanner scanner) {
        int lineLength = scanner.nextLine().length();
        String lineSeparationMatch = scanner.match().group(1);
        if (lineSeparationMatch != null) {
            lineLength += lineSeparationMatch.length();
        }
        return lineLength;
    }

    @Override
    public void insert(int beginLine, int beginColumn, String textToInsert) {
        try {
            this.tryToInsertIntoFile(beginLine, beginColumn, textToInsert);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "An exception occurred when inserting into file " + this.filePath);
        }
    }

    private void tryToInsertIntoFile(int beginLine, int beginColumn, String textToInsert) throws IOException {
        int offset = this.mapToOffset(beginLine, beginColumn);
        this.writeUntilOffsetReached(offset);
        this.writer.write(textToInsert);
    }

    private int mapToOffset(int line, int column) {
        return this.lineToOffset.get(line) + column;
    }

    private void writeUntilOffsetReached(int nextOffsetToRead) throws IOException {
        if (nextOffsetToRead < this.currentPosition) {
            throw new IllegalStateException();
        }
        char[] bufferToCopy = new char[nextOffsetToRead - this.currentPosition];
        this.reader.read(bufferToCopy);
        this.writer.write(bufferToCopy);
        this.currentPosition = nextOffsetToRead;
    }

    @Override
    public void replace(RegionByLine regionByLine, String textToReplace) {
        try {
            this.tryToReplaceInFile(this.mapToRegionByOffset(regionByLine), textToReplace);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "An exception occurred when replacing in file " + this.filePath.toAbsolutePath());
        }
    }

    private RegionByOffset mapToRegionByOffset(RegionByLine regionByLine) {
        int startOffset = this.mapToOffset(regionByLine.getBeginLine(), regionByLine.getBeginColumn());
        int endOffset = this.mapToOffset(regionByLine.getEndLine(), regionByLine.getEndColumn());
        return new RegionByOffsetImp(startOffset, endOffset - startOffset);
    }

    private void tryToReplaceInFile(RegionByOffset regionByOffset, String textToReplace) throws IOException {
        this.writeUntilOffsetReached(regionByOffset.getOffset());
        this.reader.skip(regionByOffset.getLength());
        this.currentPosition = regionByOffset.getOffsetAfterEnding();
        this.writer.write(textToReplace);
    }

    @Override
    public void delete(RegionByLine regionByOffset) {
        try {
            this.tryToDeleteFromFile(this.mapToRegionByOffset(regionByOffset));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "An exception occurred when deleting from file " + this.filePath.toAbsolutePath());
        }
    }

    private void tryToDeleteFromFile(RegionByOffset regionByOffset) throws IOException {
        this.writeUntilOffsetReached(regionByOffset.getOffset());
        this.reader.skip(regionByOffset.getLength());
        this.currentPosition = regionByOffset.getOffsetAfterEnding();
    }

    @Override
    public void close() throws IOException {
        if (this.reader.ready()) {
            this.writeUntilEOF();
        }
        this.reader.close();
        this.writer.close();
        Files.move(this.temporaryPath, this.filePath, StandardCopyOption.REPLACE_EXISTING);
    }

    private void writeUntilEOF() throws IOException {
        IOUtil.copy(this.reader, this.writer);
    }

    List<Integer> getLineToOffset() {
        return this.lineToOffset;
    }
}

