/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.cli.PMDParameters;

public final class PmdParametersParseResult {
    private final PMDParameters result;
    private final ParameterException error;
    private final Map<String, String> deprecatedOptionsUsed;
    private static final Map<String, String> SUGGESTED_REPLACEMENT;

    PmdParametersParseResult(PMDParameters result, Map<String, String> deprecatedOptionsUsed) {
        this.result = Objects.requireNonNull(result);
        this.deprecatedOptionsUsed = deprecatedOptionsUsed;
        this.error = null;
    }

    PmdParametersParseResult(ParameterException error, Map<String, String> deprecatedOptionsUsed) {
        this.result = null;
        this.error = Objects.requireNonNull(error);
        this.deprecatedOptionsUsed = deprecatedOptionsUsed;
    }

    public boolean isError() {
        return this.result == null;
    }

    public boolean isHelp() {
        return !this.isError() && this.result.isHelp();
    }

    public boolean isVersion() {
        return !this.isError() && this.result.isVersion();
    }

    public ParameterException getError() {
        return this.error;
    }

    public Map<String, String> getDeprecatedOptionsUsed() {
        return this.deprecatedOptionsUsed;
    }

    public PMDConfiguration toConfiguration() {
        return this.result != null && !this.isHelp() && !this.isVersion() ? this.result.toConfiguration() : null;
    }

    public static PmdParametersParseResult extractParameters(String ... args) {
        Objects.requireNonNull(args, "Null parameter array");
        PMDParameters result = new PMDParameters();
        JCommander jcommander = new JCommander((Object)result);
        jcommander.setProgramName("pmd");
        try {
            PmdParametersParseResult.parseAndValidate(jcommander, result, args);
            return new PmdParametersParseResult(result, PmdParametersParseResult.filterDeprecatedOptions(args));
        }
        catch (ParameterException e) {
            return new PmdParametersParseResult(e, PmdParametersParseResult.filterDeprecatedOptions(args));
        }
    }

    private static void parseAndValidate(JCommander jcommander, PMDParameters result, String[] args) {
        jcommander.parse(args);
        if (result.isHelp() || result.isVersion()) {
            return;
        }
        if (result.getInputPaths().isEmpty() && null == result.getUri() && null == result.getFileListPath()) {
            throw new ParameterException("Please provide a parameter for source root directory (--dir or -d), database URI (--uri or -u), or file list path (--file-list).");
        }
    }

    private static Map<String, String> filterDeprecatedOptions(String ... args) {
        LinkedHashMap<String, String> argSet = new LinkedHashMap<String, String>(SUGGESTED_REPLACEMENT);
        argSet.keySet().retainAll(new HashSet<String>(Arrays.asList(args)));
        return Collections.unmodifiableMap(argSet);
    }

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("-rulesets", "--rulesets (or -R)");
        m.put("-uri", "--uri");
        m.put("-dir", "--dir (or -d)");
        m.put("-filelist", "--file-list");
        m.put("-ignorelist", "--ignore-list");
        m.put("-format", "--format (or -f)");
        m.put("-debug", "--debug");
        m.put("-verbose", "--verbose");
        m.put("-help", "--help");
        m.put("-encoding", "--encoding");
        m.put("-threads", "--threads");
        m.put("-benchmark", "--benchmark");
        m.put("-stress", "--stress");
        m.put("-shortnames", "--short-names");
        m.put("-showsuppressed", "--show-suppressed");
        m.put("-suppressmarker", "--suppress-marker");
        m.put("-minimumpriority", "--minimum-priority");
        m.put("-property", "--property");
        m.put("-reportfile", "--report-file");
        m.put("-force-language", "--force-language");
        m.put("-auxclasspath", "--aux-classpath");
        m.put("-failOnViolation", "--fail-on-violation");
        m.put("--failOnViolation", "--fail-on-violation");
        m.put("-norulesetcompatibility", "--no-ruleset-compatibility");
        m.put("-cache", "--cache");
        m.put("-no-cache", "--no-cache");
        SUGGESTED_REPLACEMENT = Collections.unmodifiableMap(m);
    }
}

