/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.workspace;

import apex.jorje.lsp.api.workspace.WorkspaceChangeListener;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorkspaceChangeListenerDispatcher
implements WorkspaceChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceChangeListenerDispatcher.class);
    private final Set<WorkspaceChangeListener> listeners;
    private final Provider<ExecutorService> executorProvider;

    @Inject
    public WorkspaceChangeListenerDispatcher(Set<WorkspaceChangeListener> listeners, Provider<ExecutorService> executorProvider) {
        this.listeners = listeners;
        this.executorProvider = executorProvider;
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.listeners.forEach(listener -> {
            try {
                executor.submit(() -> listener.didChangeConfiguration(params));
            }
            catch (Exception e) {
                logger.error("Encountered an error with {}", listener, (Object)e);
            }
        });
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.listeners.forEach(listener -> {
            try {
                executor.submit(() -> listener.didChangeWatchedFiles(params));
            }
            catch (Exception e) {
                logger.error("Encountered an error with {}", listener, (Object)e);
            }
        });
    }
}

