/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.base.Initializer;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexField;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.SObjectField;
import apex.jorje.lsp.impl.index.symbol.Lookups;
import apex.jorje.lsp.impl.index.symbol.Modifiers;
import apex.jorje.lsp.impl.index.symbol.VirtualSObjectFieldTable;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.inject.Provider;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.IReader;

final class VirtualFieldTableInitializer
implements Initializer<FieldTable, TypeInfo> {
    private final SymbolResolver symbolResolver;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ApexType apexType;

    VirtualFieldTableInitializer(SymbolResolver symbolResolver, Provider<ApexIndex> apexIndexProvider, ApexType apexType) {
        this.symbolResolver = symbolResolver;
        this.apexIndexProvider = apexIndexProvider;
        this.apexType = apexType;
    }

    private FieldInfo buildFieldInfo(ApexField field, TypeInfo type) {
        return ((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setDefiningType(type)).setName(field.getFieldName().getString())).setType(Lookups.lookupByApexName(this.symbolResolver, type, field.getType().getApexName().getString(), field.getType().getBytecodeName().getString()))).setModifiers(Modifiers.toModifierGroup(field.getModifiers().getString()))).build();
    }

    private FieldInfo buildSObjectFieldInfo(ApexField field, TypeInfo type) {
        return ((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)SObjectFieldInfo.builder().setDefiningType(type)).setName(field.getFieldName().getString())).setType(Lookups.lookupByApexName(this.symbolResolver, type, field.getType().getApexName().getString(), field.getType().getBytecodeName().getString()))).setModifiers(Modifiers.toModifierGroup(field.getModifiers().getString()))).setCategory(SObjectFieldInfo.Category.valueOf(((SObjectField)field).getCategory())).setPrimaryKey(((SObjectField)field).isPrimaryKey()).build();
    }

    @Override
    public FieldTable get(TypeInfo type) {
        try (IReader ignored = ((ApexIndex)this.apexIndexProvider.get()).getNd().acquireReadLock();){
            boolean isSObject = this.apexType.isSObject();
            List<ApexField> fields = this.apexType.getFields();
            List<FieldInfo> fieldInfos = fields.stream().map(f -> isSObject ? this.buildSObjectFieldInfo((ApexField)((Object)f), type) : this.buildFieldInfo((ApexField)((Object)f), type)).collect(Collectors.toList());
            StandardFieldTable fieldTable = isSObject ? new VirtualSObjectFieldTable() : new StandardFieldTable();
            FieldTable fieldTable2 = VirtualFieldTableInitializer.create(fieldTable, fieldInfos);
            return fieldTable2;
        }
    }

    private static FieldTable create(FieldTable table, Iterable<FieldInfo> fields) {
        for (FieldInfo field : fields) {
            table.add(field).throwIfError();
        }
        return table.resolve();
    }
}

