/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl;

import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.symbol.member.method.signature.EmitSignatureFactory;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;

public class ObjectEmitMethods {
    public static final AsmMethod JAVA_EQUALS = AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(TypeInfos.OBJECT).setFunction("equals").setSignature(InternalTypeInfos.PRIMITIVE_BOOLEAN, (TypeInfo)TypeInfos.OBJECT).build();
    public static final AsmMethod JAVA_HASH_CODE = AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(TypeInfos.OBJECT).setFunction("hashCode").setSignature(InternalTypeInfos.PRIMITIVE_INTEGER).build();
    private static final Signature CONSTRUCTOR_SIGNATURE = EmitSignatureFactory.create(TypeInfos.VOID);
    private static final Signature EQUALS_BRIDGE_SIGNATURE = EmitSignatureFactory.create((TypeInfo)TypeInfos.BOOLEAN, TypeInfos.OBJECT);
    private static final Signature HASH_CODE_BRIDGE_SIGNATURE = EmitSignatureFactory.create(TypeInfos.INTEGER);

    public static AsmMethod constructor(TypeInfo type) {
        return ObjectEmitMethods.constructor(type.getBytecodeMethodName());
    }

    public static AsmMethod constructor(String definingType) {
        return AsmMethod.builder().invokeSpecial().setDefiningTypeName(definingType).setFunction("<init>").setSignature(CONSTRUCTOR_SIGNATURE).build();
    }

    public static AsmMethod constructor(TypeInfo type, TypeInfo ... params) {
        return ObjectEmitMethods.constructor(type.getBytecodeMethodName(), params);
    }

    public static AsmMethod constructor(String definingType, TypeInfo ... params) {
        return AsmMethod.builder().invokeSpecial().setDefiningTypeName(definingType).setFunction("<init>").setSignature((TypeInfo)TypeInfos.VOID, params).build();
    }

    public static AsmMethod equalsBridge(TypeInfo classType, String function) {
        assert ("equals".equalsIgnoreCase(function)) : "not equals: " + function;
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(classType).setFunction(function).setSignature(EQUALS_BRIDGE_SIGNATURE).build();
    }

    public static AsmMethod hashCodeBridge(TypeInfo classType, String function) {
        assert ("hashCode".equalsIgnoreCase(function)) : "not hashcode: " + function;
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(classType).setFunction(function).setSignature(HASH_CODE_BRIDGE_SIGNATURE).build();
    }
}

