/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.typeresolution.internal.NullableClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

final class TypesFromReflection {
    private static final Map<String, Class<?>> PRIMITIVES_BY_NAME = new HashMap();

    private TypesFromReflection() {
    }

    public static Class<?> loadClass(NullableClassLoader ctr, String className) {
        return TypesFromReflection.loadClassMaybeArray(ctr, StringUtils.deleteWhitespace((String)className));
    }

    private static Class<?> loadClassFromCanonicalName(NullableClassLoader ctr, String className) {
        Class<?> clazz = PRIMITIVES_BY_NAME.get(className);
        if (clazz == null) {
            clazz = ctr.loadClassOrNull(className);
        }
        if (clazz != null) {
            return clazz;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            String asInner = className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1);
            return TypesFromReflection.loadClassFromCanonicalName(ctr, asInner);
        }
        return null;
    }

    private static Class<?> loadClassMaybeArray(NullableClassLoader classLoader, String className) {
        Validate.notNull((Object)className, (String)"className must not be null.", (Object[])new Object[0]);
        if (className.endsWith("[]")) {
            int i;
            int dimension = 0;
            for (i = className.length(); i >= 2 && className.startsWith("[]", i - 2); i -= 2) {
                ++dimension;
            }
            TypesFromReflection.checkJavaIdent(className, i);
            String elementName = className.substring(0, i);
            Class<?> elementType = TypesFromReflection.loadClassFromCanonicalName(classLoader, elementName);
            if (elementType == null) {
                return null;
            }
            return Array.newInstance(elementType, (int[])Array.newInstance(Integer.TYPE, dimension)).getClass();
        }
        TypesFromReflection.checkJavaIdent(className, className.length());
        return TypesFromReflection.loadClassFromCanonicalName(classLoader, className);
    }

    private static IllegalArgumentException invalidClassName(String className) {
        return new IllegalArgumentException("Not a valid class name \"" + className + "\"");
    }

    private static void checkJavaIdent(String className, int endOffsetExclusive) {
        if (endOffsetExclusive <= 0 || !Character.isJavaIdentifierStart(className.charAt(0))) {
            throw TypesFromReflection.invalidClassName(className);
        }
        for (int i = 1; i < endOffsetExclusive; ++i) {
            char c = className.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            throw TypesFromReflection.invalidClassName(className);
        }
    }

    static {
        PRIMITIVES_BY_NAME.put("boolean", Boolean.TYPE);
        PRIMITIVES_BY_NAME.put("byte", Byte.TYPE);
        PRIMITIVES_BY_NAME.put("char", Character.TYPE);
        PRIMITIVES_BY_NAME.put("short", Short.TYPE);
        PRIMITIVES_BY_NAME.put("int", Integer.TYPE);
        PRIMITIVES_BY_NAME.put("long", Long.TYPE);
        PRIMITIVES_BY_NAME.put("double", Double.TYPE);
        PRIMITIVES_BY_NAME.put("float", Float.TYPE);
        PRIMITIVES_BY_NAME.put("void", Void.TYPE);
    }
}

