/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.treeexport.TreeRendererDescriptor;

abstract class TreeRendererDescriptorImpl
implements TreeRendererDescriptor {
    private final String id;
    private final String description;

    protected TreeRendererDescriptorImpl(String id, String description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public PropertySource newPropertyBundle() {
        return new PropertyBundle(this.id, this.availableDescriptors());
    }

    protected Set<PropertyDescriptor<?>> availableDescriptors() {
        return Collections.emptySet();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String description() {
        return this.description;
    }

    public String toString() {
        return "TreeDescriptorImpl{id='" + this.id + '\'' + ", description='" + this.description + '\'' + '}';
    }

    private static class PropertyBundle
    extends AbstractPropertySource {
        private final String name;

        PropertyBundle(String name, Set<PropertyDescriptor<?>> available) {
            this.name = name;
            for (PropertyDescriptor<?> p : available) {
                this.definePropertyDescriptor(p);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected String getPropertySourceType() {
            return "tree renderer";
        }
    }
}

