/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.AntlrTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.token.AntlrToken;
import net.sourceforge.pmd.cpd.token.AntlrTokenFilter;
import net.sourceforge.pmd.lang.antlr.AntlrTokenManager;
import net.sourceforge.pmd.lang.kotlin.antlr4.Kotlin;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;

public class KotlinTokenizer
extends AntlrTokenizer {
    protected AntlrTokenManager getLexerForSource(SourceCode sourceCode) {
        CharStream charStream = AntlrTokenizer.getCharStreamFromSourceCode((SourceCode)sourceCode);
        return new AntlrTokenManager((Lexer)new Kotlin(charStream), sourceCode.getFileName());
    }

    protected AntlrTokenFilter getTokenFilter(AntlrTokenManager tokenManager) {
        return new KotlinTokenFilter(tokenManager);
    }

    private static class KotlinTokenFilter
    extends AntlrTokenFilter {
        private boolean discardingPackageAndImport = false;
        private boolean discardingNL = false;

        KotlinTokenFilter(AntlrTokenManager tokenManager) {
            super(tokenManager);
        }

        protected void analyzeToken(AntlrToken currentToken) {
            this.skipPackageAndImport(currentToken);
            this.skipNewLines(currentToken);
        }

        private void skipPackageAndImport(AntlrToken currentToken) {
            int type = currentToken.getKind();
            if (type == 64 || type == 65) {
                this.discardingPackageAndImport = true;
            } else if (this.discardingPackageAndImport && (type == 33 || type == 12)) {
                this.discardingPackageAndImport = false;
            }
        }

        private void skipNewLines(AntlrToken currentToken) {
            this.discardingNL = currentToken.getKind() == 12;
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingPackageAndImport || this.discardingNL;
        }
    }
}

