/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.common.base.Result;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureEquivalence;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import java.util.Collection;
import java.util.List;

class MethodResolver {
    private final TypeInfo referencingType;

    MethodResolver(TypeInfo referencingType) {
        this.referencingType = referencingType;
    }

    Result<MethodInfo> lookup(IdentifierContext context, TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        if (SignatureUtil.isConstructor(methodName)) {
            return this.lookup(type, type.methods(), methodName, parameterTypes, MethodLookupMode.CONSTRUCTORS);
        }
        Result<MethodInfo> result = Result.none();
        switch (context) {
            case OBJECT: 
            case NONE: {
                result = this.lookupInstance(type, methodName, parameterTypes);
                if (result.hasResult()) {
                    return result;
                }
                result = this.lookupStatic(type, methodName, parameterTypes);
                break;
            }
            case STATIC: {
                result = this.lookupStatic(type, methodName, parameterTypes);
                if (result.hasResult()) {
                    return result;
                }
                result = this.lookupInstance(type, methodName, parameterTypes);
            }
        }
        if (result.hasResult()) {
            return result;
        }
        return this.lookupStaticInEnclosingType(type, methodName, parameterTypes);
    }

    private Result<MethodInfo> lookupStaticInEnclosingType(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        for (TypeInfo parent : new SuperTypeIterable(type)) {
            Result<MethodInfo> result;
            if (!TypeInfoUtil.isInnerType(parent) || !(result = this.lookupStatic(parent.getEnclosingType(), methodName, parameterTypes)).hasResult()) continue;
            return result;
        }
        return Result.none();
    }

    private Result<MethodInfo> lookupStatic(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        if (type.getBasicType() == BasicType.SOBJECT) {
            return this.lookup(type, type.methods(), methodName, parameterTypes, MethodLookupMode.STATICS);
        }
        for (TypeInfo parent : new SuperTypeIterable(type)) {
            Result<MethodInfo> result = this.lookup(parent, parent.methods(), methodName, parameterTypes, MethodLookupMode.STATICS);
            if (!result.hasResult()) continue;
            return result;
        }
        return Result.none();
    }

    private Result<MethodInfo> lookupInstance(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        Result<MethodInfo> x = this.lookup(type, type.virtualMethods(), methodName, parameterTypes, MethodLookupMode.INSTANCE);
        if (x.hasResult()) {
            return x;
        }
        if (type.getUnitType() == UnitType.INTERFACE) {
            for (TypeInfo parent : type.parents().allInterfaces()) {
                Result<MethodInfo> result = this.lookup(parent, parent.methods(), methodName, parameterTypes, MethodLookupMode.INSTANCE);
                if (!result.hasResult()) continue;
                return result;
            }
        }
        return Result.none();
    }

    private Result<MethodInfo> lookup(TypeInfo definingType, MethodTable methods, String methodName, List<TypeInfo> parameterTypes, MethodLookupMode lookupMode) {
        MethodInfo exactMethod;
        Signature signature = SignatureFactory.create(methodName, (TypeInfo)TypeInfos.VOID, parameterTypes);
        if (definingType.getCodeUnitDetails().isApexSourceBased() && !definingType.getTypeArguments().isEmpty()) {
            MethodInfo possibleMethod = null;
            for (MethodInfo method : this.getMethods(methods, lookupMode)) {
                if (!SignatureEquivalence.isEquivalent(method.getSignature(), signature)) continue;
                if (possibleMethod != null) {
                    return MethodUtil.ambiguousBind(methodName, parameterTypes);
                }
                possibleMethod = method;
            }
            exactMethod = possibleMethod;
        } else {
            exactMethod = methods.get(signature);
        }
        if (exactMethod != null) {
            switch (lookupMode) {
                case CONSTRUCTORS: {
                    if (exactMethod.getGenerated().isUserDefined()) {
                        return Result.of(exactMethod);
                    }
                }
                case STATICS: {
                    if (!exactMethod.getModifiers().has(ModifierTypeInfos.STATIC)) break;
                    return Result.of(exactMethod);
                }
                case INSTANCE: {
                    if (!exactMethod.getModifiers().not(ModifierTypeInfos.STATIC)) break;
                    return Result.of(exactMethod);
                }
            }
        }
        return methods.getApproximate(this.referencingType, methodName, parameterTypes, lookupMode);
    }

    private Collection<MethodInfo> getMethods(MethodTable methods, MethodLookupMode lookupMode) {
        switch (lookupMode) {
            case CONSTRUCTORS: {
                return methods.getConstructors();
            }
            case STATICS: {
                return methods.getStatics();
            }
            case INSTANCE: {
                return methods.getInstance();
            }
        }
        throw new UnsupportedOperationException("unknown lookup mode: " + (Object)((Object)lookupMode));
    }
}

