/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.rename;

import apex.common.base.Result;
import apex.jorje.lsp.api.rename.RenameHandler;
import apex.jorje.lsp.impl.rename.RenameUtil;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.ReferenceLocationsUtil;
import apex.jorje.lsp.impl.visitors.LocalInfoScopeVisitor;
import apex.jorje.lsp.impl.visitors.LocalNameConflictVisitor;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class LocalRenameHandler
implements RenameHandler {
    private final LocalInfo localInfo;
    private final CodeUnit codeUnit;
    private final RenameParams renameParams;
    private final Optional<Statement> containingBlock;

    LocalRenameHandler(LocalInfo localInfo, CodeUnit codeUnit, RenameParams renameParams) {
        this.localInfo = localInfo;
        this.codeUnit = codeUnit;
        this.renameParams = renameParams;
        LocalInfoScopeVisitor scopeVisitor = new LocalInfoScopeVisitor(localInfo);
        codeUnit.getNode().traverse(scopeVisitor, NoopScope.get());
        this.containingBlock = scopeVisitor.getContainingBlock();
    }

    @Override
    public List<Either<TextDocumentEdit, ResourceOperation>> getDocumentChanges() {
        if (!this.containingBlock.isPresent()) {
            return ImmutableList.of();
        }
        List referenceLocations = ReferenceLocationsUtil.getVariableReferenceLocations(this.codeUnit, this.localInfo).stream().map(location -> new TextEdit(Locations.Ranges.from(location), this.renameParams.getNewName())).collect(Collectors.toList());
        List textEdits = this.renameParams.getNewName().equalsIgnoreCase(this.localInfo.getName()) ? referenceLocations : Stream.concat(referenceLocations.stream(), RenameUtil.fieldNameRewrites(this.containingBlock.get(), this.renameParams.getNewName()).stream()).collect(Collectors.toList());
        return ImmutableList.of(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(this.renameParams.getTextDocument().getUri(), null), textEdits)));
    }

    @Override
    public Optional<String> getConflictError() {
        if (this.renameParams.getNewName().equalsIgnoreCase(this.localInfo.getName())) {
            return Optional.empty();
        }
        if (this.containingBlock.isPresent()) {
            LocalNameConflictVisitor conflictVisitor = new LocalNameConflictVisitor(this.containingBlock.get(), this.renameParams.getNewName());
            this.codeUnit.getNode().traverse(conflictVisitor, NoopScope.get());
            if (conflictVisitor.hasConflictingName()) {
                return Optional.of(I18nSupport.getLabel("new.name.conflict.local"));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> canBeRenamed() {
        return Optional.empty();
    }

    @Override
    public Optional<String> isIdentifierNameInvalid() {
        Result<Void> validationResult = IdentifierValidator.get().validate(this.localInfo.getDefiningType(), this.renameParams.getNewName(), IdentifierValidator.Type.VARIABLE, false, false);
        if (validationResult.hasError()) {
            return Optional.of(validationResult.getError());
        }
        return Optional.empty();
    }
}

