/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.connection;

import apex.jorje.lsp.api.connection.ConnectionStreamProvider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SocketStreamProvider
implements ConnectionStreamProvider {
    private static final Logger logger = LoggerFactory.getLogger(SocketStreamProvider.class);
    private final String port = System.getProperty("apex-lsp.port");
    private Socket socket;

    @Override
    public void initialize() {
        logger.info("Connecting to socket on localhost:{}", (Object)this.port);
        try {
            this.socket = new Socket("localhost", Integer.parseInt(this.port));
        }
        catch (IOException e) {
            throw new RuntimeException("Launch with -Dapex-lsp.port=somePort to connect to the server.");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }
}

