/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Available
extends SystemFunction
implements XSLTFunction {
    public static final int ELEMENT_AVAILABLE = 0;
    public static final int FUNCTION_AVAILABLE = 1;
    public static final int TYPE_AVAILABLE = 2;
    private NamespaceResolver nsContext;
    private transient StyleNodeFactory styleNodeFactory;
    private transient boolean checked = false;
    private Set importedSchemaNamespaces;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        if (!(this.argument[0] instanceof Literal) || this.argument.length != 1 && !(this.argument[1] instanceof Literal)) {
            this.nsContext = visitor.getStaticContext().getNamespaceResolver();
            if (this.operation == 2) {
                this.importedSchemaNamespaces = visitor.getStaticContext().getImportedSchemaNamespaces();
            }
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        String lexicalQName = ((Literal)this.argument[0]).getValue().getStringValue();
        StaticContext env = visitor.getStaticContext();
        boolean b = false;
        Configuration config = visitor.getConfiguration();
        switch (this.operation) {
            case 0: {
                b = ((XSLTStaticContext)env).isElementAvailable(lexicalQName);
                break;
            }
            case 1: {
                long arity = -1L;
                if (this.argument.length == 2) {
                    arity = ((NumericValue)this.argument[1].evaluateItem(env.makeEarlyEvaluationContext())).longValue();
                }
                try {
                    String[] parts = config.getNameChecker().getQNameParts(lexicalQName);
                    String prefix = parts[0];
                    String uri = prefix.length() == 0 ? env.getDefaultFunctionNamespace() : env.getURIForPrefix(prefix);
                    StructuredQName functionName = new StructuredQName(prefix, uri, parts[1]);
                    b = env.getFunctionLibrary().isAvailable(functionName, (int)arity);
                    break;
                }
                catch (QNameException e) {
                    XPathException err = new XPathException(e.getMessage());
                    err.setErrorCode("XTDE1400");
                    throw err;
                }
            }
            case 2: {
                try {
                    String[] parts = config.getNameChecker().getQNameParts(lexicalQName);
                    String prefix = parts[0];
                    String uri = prefix.length() == 0 ? env.getDefaultElementNamespace() : env.getURIForPrefix(prefix);
                    if (uri.equals("http://saxon.sf.net/java-type")) {
                        try {
                            config.getClass(parts[1], false, null);
                            b = true;
                        }
                        catch (XPathException err) {
                            b = false;
                        }
                        break;
                    }
                    int fingerprint = config.getNamePool().allocate(prefix, uri, parts[1]) & 0xFFFFF;
                    SchemaType type = config.getSchemaType(fingerprint);
                    if (type instanceof BuiltInAtomicType) {
                        b = env.isAllowedBuiltInType((BuiltInAtomicType)type);
                        break;
                    }
                    if (type instanceof BuiltInListType) {
                        b = config.isSchemaAware(50);
                        break;
                    }
                    b = type != null && (uri.equals("http://www.w3.org/2001/XMLSchema") || env.isImportedSchema(uri));
                    break;
                }
                catch (QNameException e) {
                    XPathException err = new XPathException(e.getMessage());
                    err.setErrorCode("XTDE1425");
                    throw err;
                }
            }
        }
        return Literal.makeLiteral(BooleanValue.get(b));
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StructuredQName qName;
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        long arity = -1L;
        if (this.argument.length == 2) {
            arity = ((NumericValue)this.argument[1].evaluateItem(context)).longValue();
        }
        StringValue nameValue = (StringValue)av1;
        String lexicalName = nameValue.getStringValue();
        try {
            if (lexicalName.indexOf(58) < 0) {
                String uri = this.operation == 1 ? "http://www.w3.org/2005/xpath-functions" : this.nsContext.getURIForPrefix("", true);
                qName = new StructuredQName("", uri, lexicalName);
            } else {
                qName = StructuredQName.fromLexicalQName(lexicalName, false, context.getConfiguration().getNameChecker(), this.nsContext);
            }
        }
        catch (XPathException e) {
            this.dynamicError(e.getMessage(), this.badQNameCode(), context);
            return null;
        }
        boolean b = false;
        switch (this.operation) {
            case 0: {
                b = this.isElementAvailable(qName.getNamespaceURI(), qName.getLocalName(), context);
                break;
            }
            case 1: {
                FunctionLibrary lib = context.getController().getExecutable().getFunctionLibrary();
                b = lib.isAvailable(qName, (int)arity);
                break;
            }
            case 2: {
                String uri = qName.getNamespaceURI();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") || this.importedSchemaNamespaces.contains(uri)) {
                    int fp = context.getNamePool().allocate(qName.getPrefix(), uri, qName.getLocalName()) & 0xFFFFF;
                    SchemaType type = context.getConfiguration().getSchemaType(fp);
                    b = type != null;
                    break;
                }
                return BooleanValue.FALSE;
            }
        }
        return BooleanValue.get(b);
    }

    private String badQNameCode() {
        switch (this.operation) {
            case 1: {
                return "XTDE1400";
            }
            case 2: {
                return "XTDE1428";
            }
            case 0: {
                return "XTDE1440";
            }
        }
        return null;
    }

    private boolean isElementAvailable(String uri, String localname, XPathContext context) {
        try {
            if (this.styleNodeFactory == null) {
                Configuration config = context.getConfiguration();
                this.styleNodeFactory = new StyleNodeFactory(config, context.getController().getErrorListener());
            }
            return this.styleNodeFactory.isElementAvailable(uri, localname);
        }
        catch (Exception err) {
            return false;
        }
    }
}

