/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.Locations;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;

class ParentTypeResolver {
    private static final List<TypeInfo> UNRESOLVED_INTERFACES = ImmutableList.of(UnresolvedTypeInfoFactory.get());
    private static final List<TypeInfo> TRIGGER_INTERFACES = ImmutableList.of(InternalTypeInfos.TRIGGER);
    private final Multimap<TypeInfo, CompilationException> errors;
    private final SymbolResolver symbols;

    ParentTypeResolver(Multimap<TypeInfo, CompilationException> errors, SymbolResolver symbols) {
        this.errors = errors;
        this.symbols = symbols;
    }

    TypeInfo getSuperType(TypeInfo type) {
        switch (type.getUnitType()) {
            case CLASS: {
                return type.getCodeUnitDetails().getSuperTypeRef().map(superRef -> {
                    if (superRef == null) {
                        return UnresolvedTypeInfoFactory.get();
                    }
                    if (TypeRefs.isArrayRef(superRef)) {
                        this.errors.put(type, new SemanticException(Locations.from(superRef), I18nSupport.getLabel("array.ref.not.allowed", String.valueOf(superRef))));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    TypeInfo foundType = this.symbols.lookupTypeInfo(type, (TypeRef)superRef);
                    if (!foundType.isResolved()) {
                        this.errors.putAll(type, SemanticException.create(Locations.from(superRef), UnresolvedErrorCalculator.getErrors(foundType)));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    if (foundType.getUnitType() != UnitType.CLASS || foundType.getBasicType() == BasicType.JAVA) {
                        this.errors.put(type, new SemanticException(Locations.from(superRef), I18nSupport.getLabel("invalid.class", String.valueOf(superRef))));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    return foundType;
                }).orElseGet(() -> {
                    if (TypeNameUtil.isException(type.getApexName())) {
                        this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.exception.must.extend.exception", type)));
                        return UnresolvedTypeInfoFactory.get();
                    }
                    return TypeInfos.OBJECT;
                });
            }
            case ENUM: {
                return InternalTypeInfos.ENUM;
            }
            case INTERFACE: {
                return TypeInfos.OBJECT;
            }
            case ANONYMOUS: {
                return TypeInfos.OBJECT;
            }
            case TRIGGER: {
                return TypeInfos.OBJECT;
            }
        }
        throw new UnexpectedCodePathException();
    }

    List<TypeInfo> getInterfaceTypes(TypeInfo type) {
        int size = type.getCodeUnitDetails().getInterfaceTypeRefs().size();
        switch (type.getUnitType()) {
            case CLASS: {
                ArrayList<TypeInfo> builder = new ArrayList<TypeInfo>(size);
                for (TypeRef interfaceRef : type.getCodeUnitDetails().getInterfaceTypeRefs()) {
                    if (interfaceRef == null) continue;
                    if (TypeRefs.isArrayRef(interfaceRef)) {
                        this.errors.put(type, new SemanticException(Locations.from(interfaceRef), I18nSupport.getLabel("array.ref.not.allowed", String.valueOf(interfaceRef))));
                        continue;
                    }
                    TypeInfo interfaceType = this.symbols.lookupTypeInfo(type, interfaceRef);
                    if (!interfaceType.isResolved()) {
                        this.errors.putAll(type, SemanticException.create(Locations.from(interfaceRef), UnresolvedErrorCalculator.getErrors(interfaceType)));
                        continue;
                    }
                    if (interfaceType.getUnitType() != UnitType.INTERFACE || interfaceType.getBasicType() == BasicType.JAVA) {
                        this.errors.put(type, new SemanticException(Locations.from(interfaceRef), I18nSupport.getLabel("invalid.interface", String.valueOf(interfaceRef))));
                        continue;
                    }
                    if (builder.contains(interfaceType)) {
                        this.errors.put(type, new SemanticException(Locations.from(interfaceRef), I18nSupport.getLabel("interface.already.implemented", String.valueOf(interfaceRef))));
                        continue;
                    }
                    builder.add(interfaceType);
                }
                return MoreLists.toImmutableList(builder);
            }
            case ENUM: {
                return ImmutableList.of();
            }
            case INTERFACE: {
                assert (type.getCodeUnitDetails().getInterfaceTypeRefs().size() <= 1) : "extending multiple interfaces";
                return type.getCodeUnitDetails().getInterfaceTypeRefs().stream().findFirst().map(superRef -> {
                    if (superRef == null) {
                        return UNRESOLVED_INTERFACES;
                    }
                    if (TypeRefs.isArrayRef(superRef)) {
                        this.errors.put(type, new SemanticException(Locations.from(superRef), I18nSupport.getLabel("array.ref.not.allowed", String.valueOf(superRef))));
                        return UNRESOLVED_INTERFACES;
                    }
                    TypeInfo foundType = this.symbols.lookupTypeInfo(type, (TypeRef)superRef);
                    if (!foundType.isResolved()) {
                        this.errors.putAll(type, SemanticException.create(Locations.from(superRef), UnresolvedErrorCalculator.getErrors(foundType)));
                        return UNRESOLVED_INTERFACES;
                    }
                    if (foundType.getUnitType() != UnitType.INTERFACE || foundType.getBasicType() == BasicType.JAVA) {
                        this.errors.put(type, new SemanticException(Locations.from(superRef), I18nSupport.getLabel("invalid.interface", String.valueOf(superRef))));
                        return UNRESOLVED_INTERFACES;
                    }
                    return ImmutableList.of(foundType);
                }).orElse(ImmutableList.of());
            }
            case ANONYMOUS: {
                return ImmutableList.of();
            }
            case TRIGGER: {
                return TRIGGER_INTERFACES;
            }
        }
        throw new UnexpectedCodePathException();
    }
}

