/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.exception;

import apex.common.base.MoreStrings;
import apex.common.base.Result;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.MoreLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Errors {
    private final List<CompilationException> errors = new ArrayList<CompilationException>();
    private final Set<AstNode> invalidNodes = new HashSet<AstNode>();

    private Errors() {
    }

    public static Errors createErrors() {
        return new Errors();
    }

    public void clear() {
        this.errors.clear();
        this.invalidNodes.clear();
    }

    public void addAll(Collection<? extends CompilationException> errors) {
        this.errors.addAll(errors);
    }

    public List<CompilationException> get() {
        return this.errors;
    }

    @SfdcCalled
    public CompilationException getFirst() {
        return this.errors.get(0);
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public void markInvalid(CompilationException exception) {
        this.errors.add(exception);
    }

    public void markInvalid(String message) {
        this.markInvalid(Locations.NONE, message);
    }

    @SfdcCalled
    public void markInvalid(Location loc, String message) {
        this.errors.add(new SemanticException(loc, message));
    }

    public void markInvalid(AstNode node) {
        this.invalidNodes.add(node);
    }

    public void markInvalid(AstNode node, String message) {
        this.markInvalid(node, node.getLoc(), message);
    }

    public void markInvalid(AstNode node, String message, Throwable cause) {
        SemanticException error = new SemanticException(node.getLoc(), message, cause);
        this.errors.add(error);
        this.markInvalid(node);
    }

    public void markInvalid(AstNode node, Location loc, String message) {
        SemanticException error = new SemanticException(loc, message);
        this.errors.add(error);
        this.markInvalid(node);
    }

    public void markInvalid(AstNode node, List<String> messages) {
        List errors = messages.stream().map(message -> new SemanticException(node.getLoc(), (String)message)).collect(MoreLists.toImmutableList(messages.size()));
        this.markInvalid(node, errors);
    }

    public void markInvalid(AstNode node, Collection<? extends CompilationException> errors) {
        if (!errors.isEmpty()) {
            this.errors.addAll(errors);
            this.markInvalid(node);
        }
    }

    public boolean addIfError(AstNode node, Result<?> result) {
        return this.addIfError(node, node.getLoc(), result);
    }

    public boolean addIfError(AstNode node, Location loc, Result<?> result) {
        if (result.hasError()) {
            this.markInvalid(node, loc, result.getError());
            return true;
        }
        return false;
    }

    public boolean addIfError(AstNode node, Result<?> result, I18nSupplier absentMessageSupplier) {
        return this.addIfError(node, node.getLoc(), result, absentMessageSupplier);
    }

    private boolean addIfError(AstNode node, Location loc, Result<?> result, I18nSupplier absentMessageSupplier) {
        if (result.hasError()) {
            this.markInvalid(node, loc, result.getError());
            return true;
        }
        if (result.absent()) {
            this.markInvalid(node, loc, (String)absentMessageSupplier.get());
            return true;
        }
        return false;
    }

    public boolean isInvalid(AstNode node) {
        return this.invalidNodes.contains(node);
    }

    public boolean isInvalid(AstNode node1, AstNode node2) {
        return this.isInvalid(node1) || this.isInvalid(node2);
    }

    public boolean isInvalid(AstNode node1, AstNode node2, AstNode node3) {
        return this.isInvalid(node1) || this.isInvalid(node2, node3);
    }

    public boolean isInvalid(AstNode node1, AstNode node2, AstNode node3, AstNode node4) {
        return this.isInvalid(node1) || this.isInvalid(node2, node3, node4);
    }

    public <T extends AstNode> boolean isInvalid(Collection<T> nodes) {
        for (AstNode node : nodes) {
            if (!this.invalidNodes.contains(node)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.errors.isEmpty() ? "None" : this.errors.stream().map(CompilationException::getError).collect(MoreStrings.ON_NEW_LINE);
    }
}

