/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.Location;
import apex.jorje.lsp.api.utils.SymbolPrinter;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

@Singleton
public class Symbols {
    private final SymbolPrinter printer;

    @Inject
    public Symbols(SymbolPrinter printer) {
        this.printer = printer;
    }

    private static boolean isGenerated(Location location) {
        return location.getLine() <= 0;
    }

    private static Builder from(URI uri) {
        return new Builder(uri);
    }

    public boolean isGenerated(Method method) {
        return Symbols.isGenerated(method.getLoc());
    }

    public SymbolInformation from(URI uri, UserClass userClass) {
        return Symbols.from(uri).setName(this.printer.print(userClass)).setKind(SymbolKind.Class).setLocation(userClass.getLoc()).build();
    }

    public SymbolInformation from(URI uri, UserEnum userEnum) {
        return Symbols.from(uri).setName(this.printer.print(userEnum)).setKind(SymbolKind.Enum).setLocation(userEnum.getLoc()).build();
    }

    public SymbolInformation from(URI uri, UserInterface userInterface) {
        return Symbols.from(uri).setName(this.printer.print(userInterface)).setKind(SymbolKind.Interface).setLocation(userInterface.getLoc()).build();
    }

    public SymbolInformation from(URI uri, UserTrigger userTrigger) {
        return Symbols.from(uri).setName(this.printer.print(userTrigger)).setKind(SymbolKind.Class).setLocation(userTrigger.getLoc()).build();
    }

    public SymbolInformation from(URI uri, Property property) {
        return Symbols.from(uri).setName(this.printer.print(property)).setKind(SymbolKind.Property).setLocation(property.getLoc()).build();
    }

    public SymbolInformation from(URI uri, Field field) {
        return Symbols.from(uri).setName(this.printer.print(field)).setKind(SymbolKind.Field).setLocation(field.getLoc()).build();
    }

    public SymbolInformation from(URI uri, Method method) {
        return Symbols.from(uri).setName(this.printer.print(method)).setKind(method.getMethodInfo().isConstructor() ? SymbolKind.Constructor : SymbolKind.Method).setLocation(method.getLoc()).build();
    }

    static class Builder {
        private final URI uri;
        private String name;
        private SymbolKind kind;
        private org.eclipse.lsp4j.Location location;

        Builder(URI uri) {
            this.uri = uri;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setKind(SymbolKind kind) {
            this.kind = kind;
            return this;
        }

        Builder setLocation(Location jorjeLocation) {
            this.location = Locations.from(this.uri, jorjeLocation);
            return this;
        }

        SymbolInformation build() {
            assert (this.name != null);
            assert (this.kind != null);
            assert (this.location != null);
            SymbolInformation symbol = new SymbolInformation();
            symbol.setName(this.name);
            symbol.setLocation(this.location);
            symbol.setKind(this.kind);
            return symbol;
        }
    }
}

